/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IMaterialTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabularyImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MaterialTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyImmutable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;

public class PropertyTypeImmutable
implements IPropertyTypeImmutable {
    private final PropertyType propertyType;

    PropertyTypeImmutable(String code, DataType dataType) {
        this(new PropertyType());
        this.getPropertyType().setCode(code);
        DataTypeCode typeCode = DataTypeCode.valueOf((String)dataType.name());
        this.getPropertyType().setDataType(new ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType(typeCode));
    }

    PropertyTypeImmutable(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public String getCode() {
        return this.getPropertyType().getCode();
    }

    @Override
    public String getDescription() {
        return this.getPropertyType().getDescription();
    }

    @Override
    public String getLabel() {
        return this.getPropertyType().getLabel();
    }

    @Override
    public DataType getDataType() {
        String typeName = this.getPropertyType().getDataType().getCode().name();
        return DataType.valueOf(typeName);
    }

    @Override
    public IMaterialTypeImmutable getMaterialType() {
        MaterialType materialType = this.getPropertyType().getMaterialType();
        if (materialType != null) {
            return new MaterialTypeImmutable(materialType);
        }
        return null;
    }

    @Override
    public String getXmlSchema() {
        return this.getPropertyType().getSchema();
    }

    @Override
    public String getTransformation() {
        return this.getPropertyType().getTransformation();
    }

    @Override
    public boolean isManagedInternally() {
        return this.getPropertyType().isManagedInternally();
    }

    @Override
    public boolean isInternalNamespace() {
        return this.isManagedInternally();
    }

    @Override
    public IVocabularyImmutable getVocabulary() {
        Vocabulary vocabulary = this.getPropertyType().getVocabulary();
        if (vocabulary != null) {
            return new VocabularyImmutable(vocabulary);
        }
        return null;
    }
}

