/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.plugin;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.plugin.IServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.IServerPluginWithWildcards;
import ch.systemsx.cisd.openbis.generic.server.plugin.WildcardSupportingPluginMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKindAndTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

abstract class AbstractPluginRegistry<P extends IServerPlugin>
implements BeanFactoryAware {
    private final Logger operationLog;
    private final WildcardSupportingPluginMap<P> pluginMap = new WildcardSupportingPluginMap();
    private P genericServerPlugin;

    protected AbstractPluginRegistry() {
        this.operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
    }

    public final synchronized void registerPlugin(P plugin) {
        if (plugin instanceof IServerPluginWithWildcards) {
            this.registerPluginWithWildcards(plugin);
        } else {
            this.registerPluginWithoutWildcards(plugin);
        }
    }

    private final synchronized void registerPluginWithWildcards(P plugin) {
        assert (plugin != null) : "Unspecified plugin.";
        for (EntityKind entityKind : EntityKind.values()) {
            for (String entityTypeCode : ((IServerPluginWithWildcards)plugin).getOrderedEntityTypeCodes(entityKind)) {
                EntityKindAndTypeCode key = new EntityKindAndTypeCode(entityKind, entityTypeCode);
                this.pluginMap.addMapping(key, plugin);
            }
        }
    }

    private final synchronized void registerPluginWithoutWildcards(P plugin) {
        assert (plugin != null) : "Unspecified plugin.";
        for (EntityKind entityKind : EntityKind.values()) {
            for (String entityTypeCode : plugin.getEntityTypeCodes(entityKind)) {
                EntityKindAndTypeCode key = new EntityKindAndTypeCode(entityKind, entityTypeCode);
                P previousPlugin = this.pluginMap.tryPlugin(key);
                if (previousPlugin != null) {
                    this.operationLog.error((Object)String.format("There is already a plugin '%s' registered for entity kind '%s' and entity type '%s.'", previousPlugin.getClass().getName(), entityKind, entityTypeCode));
                } else if (this.operationLog.isInfoEnabled()) {
                    this.operationLog.info((Object)String.format("Plugin '%s' registered for entity kind '%s' and entity type '%s.'", plugin.getClass().getName(), entityKind, entityTypeCode));
                }
                this.pluginMap.addMapping(key, plugin);
            }
        }
    }

    public final synchronized P getPlugin(EntityKind entityKind, EntityTypePE entityType) {
        assert (entityKind != null) : "Unspecified entity kind.";
        assert (entityType != null) : "Unspecified entity type.";
        P serverPlugin = this.pluginMap.tryPlugin(new EntityKindAndTypeCode(entityKind, entityType.getCode()));
        return serverPlugin == null ? this.genericServerPlugin : serverPlugin;
    }

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.genericServerPlugin = (IServerPlugin)beanFactory.getBean(this.getBeanNameOfGenericPlugin());
    }

    protected abstract String getBeanNameOfGenericPlugin();
}

