/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.string.StringUtilities;
import ch.systemsx.cisd.openbis.generic.server.task.IChangedHandler;
import ch.systemsx.cisd.openbis.generic.server.task.UserManagerConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

abstract class AbstractMaintenanceTask
implements IMaintenanceTask {
    static final String CONFIGURATION_FILE_PATH_PROPERTY = "configuration-file-path";
    static final String DEFAULT_CONFIGURATION_FILE_PATH = "etc/user-management-maintenance-config.json";
    private final boolean configMandatory;
    protected final Logger operationLog;
    protected final Logger notificationLog;
    protected File configurationFile;
    protected MaintenanceTaskParameters parameters;

    AbstractMaintenanceTask(boolean configMandatory) {
        this.configMandatory = configMandatory;
        this.operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
        this.notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, this.getClass());
    }

    public void setUp(String pluginName, Properties properties) {
        this.operationLog.info((Object)("Setup plugin " + pluginName));
        this.configurationFile = new File(properties.getProperty(CONFIGURATION_FILE_PATH_PROPERTY, DEFAULT_CONFIGURATION_FILE_PATH));
        if (this.configMandatory && !this.configurationFile.isFile()) {
            throw new ConfigurationFailureException("Configuration file '" + this.configurationFile.getAbsolutePath() + "' doesn't exist or is a directory.");
        }
        this.parameters = new MaintenanceTaskParameters(properties, pluginName);
        this.setUpSpecific(properties);
        this.operationLog.info((Object)("Plugin '" + pluginName + "' initialized." + (this.configurationFile.isFile() ? " Configuration file: " + this.configurationFile.getAbsolutePath() : "")));
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    protected abstract void setUpSpecific(Properties var1);

    protected UserManagerConfig readGroupDefinitions(IChangedHandler handlerOrNull) {
        if (!this.configurationFile.isFile()) {
            if (this.configMandatory) {
                this.operationLog.error((Object)("Configuration file '" + this.configurationFile.getAbsolutePath() + "' doesn't exist or is a directory."));
            }
            return null;
        }
        String serializedConfig = FileUtilities.loadToString((File)this.configurationFile);
        try {
            ObjectMapper mapper = new ObjectMapper();
            UserManagerConfig config = (UserManagerConfig)mapper.readValue(serializedConfig, UserManagerConfig.class);
            boolean hasChanged = this.hasChanged(serializedConfig);
            if (hasChanged && handlerOrNull != null) {
                handlerOrNull.changed(serializedConfig, new Date(this.configurationFile.lastModified()));
            }
            return config;
        }
        catch (Exception e) {
            this.operationLog.error((Object)("Invalid content of configuration file '" + this.configurationFile.getAbsolutePath() + "': " + e), (Throwable)e);
            return null;
        }
    }

    private boolean hasChanged(String serializedConfig) {
        String hash = StringUtilities.computeMD5Hash((String)(this.configurationFile.lastModified() + serializedConfig));
        File hashFile = new File(this.configurationFile.getParentFile(), this.configurationFile.getName() + ".hash");
        String previousHash = null;
        if (hashFile.isFile()) {
            previousHash = FileUtilities.loadExactToString((File)hashFile);
        }
        FileUtilities.writeToFile((File)hashFile, (String)hash);
        return !hash.equals(previousHash);
    }
}

