/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ArchivingStatus;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.archive.DataSetArchiveOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.PhysicalDataSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.task.AbstractMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.MaintenanceTaskUtils;
import ch.systemsx.cisd.openbis.generic.server.task.UserGroup;
import ch.systemsx.cisd.openbis.generic.server.task.UserManagerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ArchivingByRequestTask
extends AbstractMaintenanceTask {
    static final String KEEP_IN_STORE = "keep-in-store";
    static final String MINIMUM_CONTAINER_SIZE_IN_BYTES = "minimum-container-size-in-bytes";
    static final long DEFAULT_MINIMUM_CONTAINER_SIZE_IN_BYTES = 0x280000000L;
    static final String MAXIMUM_CONTAINER_SIZE_IN_BYTES = "maximum-container-size-in-bytes";
    static final long DEFAULT_MAXIMUM_CONTAINER_SIZE_IN_BYTES = 0x1400000000L;
    private long minimumContainerSize;
    private long maximumContainerSize;
    private boolean keepInStore;

    public ArchivingByRequestTask() {
        super(false);
    }

    @Override
    protected void setUpSpecific(Properties properties) {
        this.keepInStore = PropertyUtils.getBoolean((Properties)properties, (String)KEEP_IN_STORE, (boolean)false);
        this.minimumContainerSize = PropertyUtils.getLong((Properties)properties, (String)MINIMUM_CONTAINER_SIZE_IN_BYTES, (long)0x280000000L);
        this.maximumContainerSize = PropertyUtils.getLong((Properties)properties, (String)MAXIMUM_CONTAINER_SIZE_IN_BYTES, (long)0x1400000000L);
        if (this.maximumContainerSize <= this.minimumContainerSize) {
            throw new ConfigurationFailureException("minimum-container-size-in-bytes=" + this.minimumContainerSize + " has to be less than " + MAXIMUM_CONTAINER_SIZE_IN_BYTES + "=" + this.maximumContainerSize);
        }
        if (this.minimumContainerSize < 0L) {
            throw new ConfigurationFailureException("minimum-container-size-in-bytes=" + this.minimumContainerSize + " has to be greater or equal zero.");
        }
    }

    public void execute() {
        IApplicationServerInternalApi service = this.getService();
        if (!MaintenanceTaskUtils.areAllDataStoreServersRunning(service)) {
            this.operationLog.info((Object)"Not executed because DSS isn't running (yet).");
            return;
        }
        String sessionToken = service.loginAsSystem();
        List<DataSet> dataSets = this.getDataSetsToBeArchived(service, sessionToken);
        this.operationLog.info((Object)(dataSets.size() + " data sets to be archived."));
        Map<String, List<DataSet>> dataSetsByGroups = this.getDataSetsByGroups(this.getGroups(), dataSets);
        for (Map.Entry<String, List<DataSet>> entry : dataSetsByGroups.entrySet()) {
            String groupKey = entry.getKey();
            List items = entry.getValue().stream().map(DataSetHolder::new).collect(Collectors.toList());
            this.operationLog.info((Object)("Archive " + items.size() + " data sets" + (StringUtils.isNotBlank((CharSequence)groupKey) ? " for group " + groupKey : "") + "."));
            List chunks = ArchivingByRequestTask.getChunks(items, this.minimumContainerSize, this.maximumContainerSize);
            for (List chunk : chunks) {
                List ids;
                if (chunk.size() == 1 && ((DataSetHolder)chunk.get(0)).getDataSet().getPhysicalData().getSize() > this.maximumContainerSize) {
                    this.operationLog.warn((Object)("Data set " + ((DataSetHolder)chunk.get(0)).getDataSet().getPermId() + " is larger than the " + MAXIMUM_CONTAINER_SIZE_IN_BYTES + ": " + ((DataSetHolder)chunk.get(0)).getDataSet().getPhysicalData().getSize() + " > " + this.maximumContainerSize));
                }
                if ((ids = chunk.stream().map(i -> i.getDataSet().getPermId()).collect(Collectors.toList())).isEmpty()) continue;
                DataSetArchiveOptions archiveOptions = new DataSetArchiveOptions();
                archiveOptions.setRemoveFromDataStore(!this.keepInStore);
                if (StringUtils.isNotBlank((CharSequence)groupKey)) {
                    archiveOptions.withOption("sub-directory", groupKey.toLowerCase());
                }
                service.archiveDataSets(sessionToken, ids, archiveOptions);
            }
        }
    }

    static <T extends SizeHolder> List<List<T>> getChunks(List<T> items, long minChunkSize, long maxChunkSize) {
        Collections.sort(items, new SimpleComparator<T, Long>(){

            public Long evaluate(T item) {
                return -item.getSize();
            }
        });
        ArrayList<List<T>> chunks = new ArrayList<List<T>>();
        ArrayList<SizeHolder> currentChunk = new ArrayList<SizeHolder>();
        long currentChunkSize = 0L;
        for (SizeHolder item : items) {
            long size = item.getSize();
            if (size >= maxChunkSize) {
                chunks.add(Arrays.asList(item));
                continue;
            }
            if (currentChunkSize >= minChunkSize) {
                if (currentChunkSize + size > maxChunkSize) {
                    chunks.add(currentChunk);
                    currentChunk = new ArrayList();
                    currentChunkSize = 0L;
                }
                currentChunk.add(item);
                currentChunkSize += size;
                continue;
            }
            if (currentChunkSize + size >= maxChunkSize) continue;
            currentChunk.add(item);
            currentChunkSize += size;
        }
        if (currentChunkSize >= minChunkSize) {
            chunks.add(currentChunk);
        }
        return chunks;
    }

    private List<DataSet> getDataSetsToBeArchived(IApplicationServerInternalApi service, String sessionToken) {
        DataSetSearchCriteria searchCriteria = new DataSetSearchCriteria();
        PhysicalDataSearchCriteria physicalSearchCriteria = searchCriteria.withPhysicalData();
        physicalSearchCriteria.withPresentInArchive().thatEquals(false);
        physicalSearchCriteria.withArchivingRequested().thatEquals(true);
        physicalSearchCriteria.withStatus().thatEquals((Enum)ArchivingStatus.AVAILABLE);
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withDataStore();
        fetchOptions.withPhysicalData();
        fetchOptions.withExperiment().withProject().withSpace();
        fetchOptions.withSample().withProject().withSpace();
        fetchOptions.withSample().withSpace();
        List dataSets = service.searchDataSets(sessionToken, searchCriteria, fetchOptions).getObjects();
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        ArrayList<String> dataSetsWithUnknownSize = new ArrayList<String>();
        for (DataSet dataSet : dataSets) {
            Long size = dataSet.getPhysicalData().getSize();
            if (size == null) {
                dataSetsWithUnknownSize.add(dataSet.getCode());
                continue;
            }
            result.add(dataSet);
        }
        if (!dataSetsWithUnknownSize.isEmpty()) {
            this.operationLog.warn((Object)("The size of the following data sets is unknown: " + CollectionUtils.abbreviate(dataSetsWithUnknownSize, (int)100)));
        }
        return result;
    }

    private Set<String> getGroups() {
        TreeSet<String> groupKeys = new TreeSet<String>();
        UserManagerConfig groupDefinitions = this.readGroupDefinitions(null);
        if (groupDefinitions != null) {
            List<UserGroup> groups = groupDefinitions.getGroups();
            for (UserGroup group : groups) {
                groupKeys.add(group.getKey());
            }
        }
        return groupKeys;
    }

    private Map<String, List<DataSet>> getDataSetsByGroups(Set<String> groupKeys, List<DataSet> dataSets) {
        TreeMap<String, List<DataSet>> dataSetsByGroups = new TreeMap<String, List<DataSet>>();
        for (DataSet dataSet : dataSets) {
            ArrayList<DataSet> list;
            String prefix;
            String spaceCode = dataSet.getExperiment().getProject().getSpace().getCode();
            String[] prefixAndCode = StringUtils.split((String)spaceCode, (String)"_", (int)2);
            String groupKey = "";
            if (prefixAndCode.length == 2 && groupKeys.contains(prefix = prefixAndCode[0])) {
                groupKey = prefix;
            }
            if ((list = (ArrayList<DataSet>)dataSetsByGroups.get(groupKey)) == null) {
                list = new ArrayList<DataSet>();
                dataSetsByGroups.put(groupKey, list);
            }
            list.add(dataSet);
        }
        return dataSetsByGroups;
    }

    protected IApplicationServerInternalApi getService() {
        return CommonServiceProvider.getApplicationServerApi();
    }

    private static class DataSetHolder
    implements SizeHolder {
        private final DataSet dataSet;

        public DataSetHolder(DataSet dataSet) {
            this.dataSet = dataSet;
        }

        @Override
        public long getSize() {
            return this.dataSet.getPhysicalData().getSize();
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }
    }

    static interface SizeHolder {
        public long getSize();
    }
}

