/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.business.bo.SampleCodeGeneratorByType;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.exception.SampleUniqueCodeViolationException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class BatchSampleRegistrationTempCodeUpdaterTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, BatchSampleRegistrationTempCodeUpdaterTask.class);
    private BatchSampleRegistrationTempCodeUpdaterBean bean;

    public void setUp(String pluginName, Properties properties) {
    }

    public void execute() {
        ApplicationContext applicationContext = CommonServiceProvider.getApplicationContext();
        operationLog.info((Object)"BatchSampleRegistrationTempCodeUpdaterTask started.");
        while (true) {
            try {
                this.getBean(applicationContext).execute();
            }
            catch (RuntimeException ex) {
                Throwable originalException;
                if ((originalException = ExceptionUtils.getEndOfChain((Throwable)ex)) instanceof SampleUniqueCodeViolationException) continue;
                operationLog.error((Object)("Code updating failed: " + ex.getMessage()), (Throwable)ex);
            }
            break;
        }
        operationLog.info((Object)"BatchSampleRegistrationTempCodeUpdaterTask finished executing.");
    }

    private BatchSampleRegistrationTempCodeUpdaterBean getBean(ApplicationContext applicationContext) {
        if (this.bean == null) {
            AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
            this.bean = (BatchSampleRegistrationTempCodeUpdaterBean)beanFactory.createBean(BatchSampleRegistrationTempCodeUpdaterBean.class);
        }
        return this.bean;
    }

    static class BatchSampleRegistrationTempCodeUpdaterBean {
        BatchSampleRegistrationTempCodeUpdaterBean() {
        }

        @Transactional
        public void execute() {
            IDAOFactory daoFactory = CommonServiceProvider.getDAOFactory();
            ISampleTypeDAO sampleTypeDAO = daoFactory.getSampleTypeDAO();
            ISampleDAO sampleDAO = daoFactory.getSampleDAO();
            ISampleListingQuery sampleListingQuery = (ISampleListingQuery)QueryTool.getManagedQuery(ISampleListingQuery.class);
            DataIterator<SampleRecord> samplesWithTemporaryCodes = sampleListingQuery.getSamplesWithTemporaryCodes();
            if (!samplesWithTemporaryCodes.hasNext()) {
                return;
            }
            ICommonServerForInternalUse server = CommonServiceProvider.getCommonServer();
            SessionContextDTO contextOrNull = server.tryToAuthenticateAsSystem();
            Person systemUser = null;
            if (contextOrNull == null) {
                throw new RuntimeException("Authentication failed.");
            }
            String sessionToken = contextOrNull.getSessionToken();
            List<Person> persons = server.listPersons(sessionToken);
            systemUser = persons.get(0);
            IPersonDAO personDAO = daoFactory.getPersonDAO();
            PersonPE personPE = personDAO.tryFindPersonByUserId(systemUser.getUserId());
            if (personPE == null) {
                throw new RuntimeException("User with id " + systemUser.getUserId() + " not found.");
            }
            List<SampleTypePE> sampleTypes = sampleTypeDAO.listSampleTypes();
            HashMap<Long, SampleTypePE> techIdsToSampleTypes = new HashMap<Long, SampleTypePE>();
            for (SampleTypePE sampleTypePE : sampleTypes) {
                techIdsToSampleTypes.put(sampleTypePE.getId(), sampleTypePE);
            }
            HashMap<Long, SampleRecord> techIdsToSampleRecords = new HashMap<Long, SampleRecord>();
            HashMap<String, ArrayList<SampleRecord>> codePrefixToSampleRecords = new HashMap<String, ArrayList<SampleRecord>>();
            for (SampleRecord sampleRecord : samplesWithTemporaryCodes) {
                long sampleTypeId = sampleRecord.saty_id;
                String codePrefix = ((SampleTypePE)techIdsToSampleTypes.get(sampleTypeId)).getGeneratedCodePrefix();
                ArrayList<SampleRecord> list = (ArrayList<SampleRecord>)codePrefixToSampleRecords.get(codePrefix);
                if (list == null) {
                    list = new ArrayList<SampleRecord>();
                    codePrefixToSampleRecords.put(codePrefix, list);
                }
                list.add(sampleRecord);
                techIdsToSampleRecords.put(sampleRecord.id, sampleRecord);
            }
            operationLog.info((Object)(techIdsToSampleRecords.keySet().size() + " samples with temp codes were found."));
            HashMap<Long, String> techIdsToNewSampleCodes = new HashMap<Long, String>();
            SampleCodeGeneratorByType sampleCodeGeneratorByType = new SampleCodeGeneratorByType(daoFactory);
            for (String codePrefix : codePrefixToSampleRecords.keySet()) {
                List sampleRecords = (List)codePrefixToSampleRecords.get(codePrefix);
                int noOfCodesToGenerate = sampleRecords.size();
                List<String> generatedCodes = sampleCodeGeneratorByType.generateCodes(codePrefix, EntityKind.SAMPLE, noOfCodesToGenerate);
                for (int i = 0; i < noOfCodesToGenerate; ++i) {
                    techIdsToNewSampleCodes.put(((SampleRecord)sampleRecords.get((int)i)).id, generatedCodes.get(i));
                }
            }
            List<SamplePE> samplePEs = sampleDAO.listByIDs(techIdsToSampleRecords.keySet());
            for (SamplePE samplePE : samplePEs) {
                String newSampleCode = (String)techIdsToNewSampleCodes.get(samplePE.getId());
                samplePE.setCode(newSampleCode);
            }
            sampleDAO.createOrUpdateSamples(samplePEs, personPE, true);
        }
    }
}

