/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICacheManager;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.task.AbstractMaintenanceTask;
import java.util.Date;
import java.util.Properties;

public class CacheClearanceMaintenanceTask
extends AbstractMaintenanceTask {
    private int cacheTimeout = 3600;
    private ICacheManager cacheManager;

    public CacheClearanceMaintenanceTask() {
        super(false);
    }

    @Override
    protected void setUpSpecific(Properties properties) {
        this.cacheManager = (ICacheManager)CommonServiceProvider.getApplicationContext().getBean(ICacheManager.class);
        this.cacheTimeout = PropertyUtils.getInt((Properties)properties, (String)"api.v3.operation-execution.cache.timeout", (int)3600);
    }

    public void execute() {
        this.notificationLog.info((Object)"Cache clearance execution started.");
        this.cacheManager.clearOld(new Date(new Date().getTime() - (long)this.cacheTimeout * 1000L));
        this.notificationLog.info((Object)"Cache clearance execution finished.");
    }
}

