/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DemoMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DemoMaintenanceTask.class);

    public void execute() {
        IProjectDAO projectDAO = CommonServiceProvider.getDAOFactory().getProjectDAO();
        List<ProjectPE> projects = projectDAO.listProjects();
        operationLog.info((Object)(projects.size() + " project(s) found"));
        ICommonServerForInternalUse server = CommonServiceProvider.getCommonServer();
        SessionContextDTO contextOrNull = server.tryToAuthenticateAsSystem();
        if (contextOrNull != null) {
            String sessionToken = contextOrNull.getSessionToken();
            List<Person> persons = server.listPersons(sessionToken);
            operationLog.info((Object)(persons.size() + " person(s) found"));
        } else {
            operationLog.error((Object)"authentication failed");
        }
        operationLog.info((Object)"task executed");
    }

    public void setUp(String pluginName, Properties properties) {
        operationLog.info((Object)("Plugin " + pluginName + " initialized with properties:\n" + properties));
    }
}

