/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.DataStore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.fetchoptions.DataStoreFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.search.DataStoreSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import java.io.File;
import java.util.List;

public class MaintenanceTaskUtils {
    private static final File STARTED_FILE = new File("SERVER_STARTED");

    public static boolean areAllDataStoreServersRunning(IApplicationServerInternalApi service) {
        if (!STARTED_FILE.exists()) {
            return false;
        }
        long startUpTimestampOfAS = STARTED_FILE.lastModified();
        String sessionToken = service.loginAsSystem();
        DataStoreSearchCriteria searchCriteria = new DataStoreSearchCriteria();
        DataStoreFetchOptions fetchOptions = new DataStoreFetchOptions();
        List dataStores = service.searchDataStores(sessionToken, searchCriteria, fetchOptions).getObjects();
        for (DataStore dataStore : dataStores) {
            if (dataStore.getModificationDate().getTime() >= startUpTimestampOfAS) continue;
            return false;
        }
        return true;
    }
}

