/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.openbis.generic.server.task.Period;
import java.util.Date;
import java.util.GregorianCalendar;

enum PeriodType {
    DAYLY(86400000L){

        @Override
        protected Period getPeriod(GregorianCalendar calendar) {
            long until = calendar.getTimeInMillis();
            return new Period(new Date(until - 86400000L), new Date(until));
        }
    }
    ,
    WEEKLY(604800000L){

        @Override
        protected Period getPeriod(GregorianCalendar calendar) {
            calendar.set(7, 1);
            long until = calendar.getTimeInMillis();
            return new Period(new Date(until - 604800000L), new Date(until));
        }
    }
    ,
    MONTHLY(2678400000L){

        @Override
        protected Period getPeriod(GregorianCalendar calendar) {
            calendar.set(5, 1);
            Date until = calendar.getTime();
            int currentMonth = calendar.get(2);
            if (currentMonth == 0) {
                calendar.set(2, 11);
                calendar.set(1, calendar.get(1) - 1);
            } else {
                calendar.set(2, currentMonth - 1);
            }
            Date from = calendar.getTime();
            return new Period(from, until);
        }
    };

    private long periodLength;

    static PeriodType getBestType(long interval) {
        PeriodType[] values;
        for (PeriodType periodType : values = PeriodType.values()) {
            if (interval > periodType.periodLength) continue;
            return periodType;
        }
        return values[values.length - 1];
    }

    private PeriodType(long periodLength) {
        this.periodLength = periodLength;
    }

    Period getPeriod(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return this.getPeriod(calendar);
    }

    protected abstract Period getPeriod(GregorianCalendar var1);
}

