/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RemoveUnusedUnofficialTermsMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RemoveUnusedUnofficialTermsMaintenanceTask.class);
    private static final String OLDER_THAN_DAYS_PROPERTY_NAME = "older-than-days";
    private static final Double DEFAULT_OLDER_THAN_DAYS = 7.0;
    private long olderThan;
    private final double day = 8.64E7;

    public void setUp(String pluginName, Properties properties) {
        double olderThanDouble = PropertyUtils.getDouble((Properties)properties, (String)OLDER_THAN_DAYS_PROPERTY_NAME, (double)DEFAULT_OLDER_THAN_DAYS);
        this.olderThan = Math.round(olderThanDouble * 8.64E7);
        operationLog.info((Object)("Unused unofficial terms older than " + olderThanDouble + " days (" + this.olderThan + " milliseconds) will be removed."));
    }

    public void execute() {
        ICommonServerForInternalUse server = CommonServiceProvider.getCommonServer();
        SessionContextDTO contextOrNull = server.tryToAuthenticateAsSystem();
        if (contextOrNull != null) {
            String sessionToken = contextOrNull.getSessionToken();
            List<Vocabulary> vocabularies = server.listVocabularies(sessionToken, false, true);
            for (Vocabulary vocabulary : vocabularies) {
                List<VocabularyTermWithStats> termsWithStats = server.listVocabularyTermsWithStatistics(sessionToken, vocabulary);
                ArrayList<VocabularyTerm> termsToBeDeleted = new ArrayList<VocabularyTerm>();
                for (VocabularyTermWithStats term : termsWithStats) {
                    if (term.getTerm().isOfficial().booleanValue() || new Date().getTime() - term.getTerm().getRegistrationDate().getTime() <= this.olderThan) continue;
                    int usage = 0;
                    for (EntityKind entityKind : EntityKind.values()) {
                        usage = (int)((long)usage + term.getUsageCounter(entityKind));
                    }
                    if (usage != 0) continue;
                    VocabularyTerm vocabularyTerm = VocabularyTermTranslator.translate(term.getTerm());
                    operationLog.info((Object)("Term '" + vocabularyTerm + "' will be deleted."));
                    termsToBeDeleted.add(vocabularyTerm);
                }
                if (termsToBeDeleted.size() <= 0) continue;
                server.deleteVocabularyTerms(sessionToken, TechId.create((IIdHolder)vocabulary), termsToBeDeleted, new ArrayList<VocabularyTermReplacement>());
            }
        } else {
            operationLog.error((Object)"authentication failed");
        }
        operationLog.info((Object)"task executed");
    }
}

