/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.ISessionWorkspaceProvider;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SessionWorkspaceCleanUpMaintenanceTask
implements IMaintenanceTask {
    public static final String DEFAULT_MAINTENANCE_TASK_NAME = "session-workspace-clean-up-task";
    public static final int DEFAULT_MAINTENANCE_TASK_INTERVAL = 3600;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SessionWorkspaceCleanUpMaintenanceTask.class);
    private IApplicationServerApi applicationServerApi;
    private ISessionWorkspaceProvider sessionWorkspaceProvider;

    public SessionWorkspaceCleanUpMaintenanceTask() {
        this(CommonServiceProvider.getApplicationServerApi(), (ISessionWorkspaceProvider)CommonServiceProvider.tryToGetBean("session-workspace-provider"));
    }

    SessionWorkspaceCleanUpMaintenanceTask(IApplicationServerApi applicationServerApi, ISessionWorkspaceProvider sessionWorkspaceProvider) {
        this.applicationServerApi = applicationServerApi;
        this.sessionWorkspaceProvider = sessionWorkspaceProvider;
    }

    public void setUp(String pluginName, Properties properties) {
        operationLog.info((Object)("Setup plugin " + pluginName));
    }

    public void execute() {
        Map<String, File> sessionWorkspaces = this.sessionWorkspaceProvider.getSessionWorkspaces();
        int count = 0;
        for (String sessionToken : sessionWorkspaces.keySet()) {
            if (this.applicationServerApi.isSessionActive(sessionToken)) continue;
            operationLog.info((Object)("Session '" + sessionToken + "' is no longer active. Its session workspace will be removed."));
            this.sessionWorkspaceProvider.deleteSessionWorkspace(sessionToken);
            ++count;
        }
        operationLog.info((Object)("Session workspace clean up finished. Removed " + count + " workspace(s) of inactive session(s)."));
    }
}

