/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.PersonSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.common.http.JettyHttpClientFactory;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.task.AbstractMaintenanceTask;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;

public class StatisticsCollectionMaintenanceTask
extends AbstractMaintenanceTask {
    public static final String DEFAULT_MAINTENANCE_TASK_NAME = "statistics-collection-task";
    public static final int DEFAULT_MAINTENANCE_TASK_INTERVAL = 86400;
    private static final String SERVER_ID_DOCUMENT_VERSION_FILE_PATH = "etc/instance-id";
    private final IApplicationServerInternalApi applicationServerApi;
    private boolean firstCall = true;

    public StatisticsCollectionMaintenanceTask() {
        this(CommonServiceProvider.getApplicationServerApi());
    }

    StatisticsCollectionMaintenanceTask(IApplicationServerInternalApi applicationServerApi) {
        super(false);
        this.applicationServerApi = applicationServerApi;
    }

    @Override
    protected void setUpSpecific(Properties properties) {
    }

    public void execute() {
        if (this.shouldExecute()) {
            byte[] body;
            this.notificationLog.info((Object)"Statistics collection execution started.");
            String sessionToken = this.applicationServerApi.loginAsSystem();
            long personsCount = this.getPersonsCount(sessionToken);
            EnumMap<StatisticsKeys, String> statisticsMap = new EnumMap<StatisticsKeys, String>(StatisticsKeys.class);
            statisticsMap.put(StatisticsKeys.SERVER_ID, this.getThisServerId());
            statisticsMap.put(StatisticsKeys.USERS_COUNT, String.valueOf(personsCount));
            statisticsMap.put(StatisticsKeys.OPENBIS_VERSION, BuildAndEnvironmentInfo.INSTANCE.getVersion());
            statisticsMap.put(StatisticsKeys.SUBMISSION_TIMESTAMP, Instant.now().toString());
            try {
                body = JacksonObjectMapper.getInstance().writeValue(statisticsMap);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error mapping JSON object.", e);
            }
            Request request = JettyHttpClientFactory.getHttpClient().POST("http://statistics.openbis.ch/statistics").content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{body}));
            try {
                ContentResponse contentResponse = request.send();
                contentResponse.getContent();
                int statusCode = contentResponse.getStatus();
                if (statusCode >= 400) {
                    this.notificationLog.warn((Object)String.format("Error sending statistics collection request. Error code received: %d (%s)", statusCode, contentResponse.getReason()));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.notificationLog.warn((Object)"Error sending statistics collection request.", (Throwable)e);
            }
            this.notificationLog.info((Object)"Statistics collection execution finished.");
        }
    }

    private boolean shouldExecute() {
        String disableStatistics = System.getenv().get("DISABLE_OPENBIS_STATISTICS");
        if (!"true".equals(disableStatistics)) {
            boolean propertyIsMissing;
            String collectStatistics = ((ExposablePropertyPlaceholderConfigurer)CommonServiceProvider.tryToGetBean("propertyConfigurer")).getResolvedProps().getProperty("collect-statistics");
            boolean bl = propertyIsMissing = collectStatistics == null || collectStatistics.isEmpty();
            if ("true".equals(collectStatistics) || propertyIsMissing) {
                if (propertyIsMissing) {
                    this.operationLog.warn((Object)"The collect-statistics property is missing. Statistics data is sent by default.");
                }
                if (this.firstCall) {
                    this.firstCall = false;
                    return true;
                }
                return Calendar.getInstance().get(5) == 1;
            }
        }
        return false;
    }

    private String getThisServerId() {
        File file = new File(SERVER_ID_DOCUMENT_VERSION_FILE_PATH);
        String idFromFile = this.readIdFromFile(file);
        if (idFromFile != null) {
            return idFromFile;
        }
        String generatedId = UUID.randomUUID().toString();
        this.writeVersionToFile(file, generatedId);
        return generatedId;
    }

    private void writeVersionToFile(File file, String version) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(version.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readIdFromFile(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (NoSuchFileException e) {
            this.operationLog.debug((Object)String.format("File '%s' not found", file.getAbsolutePath()));
            return null;
        }
        catch (IOException e) {
            this.operationLog.error((Object)String.format("Error reading from file '%s'", file.getAbsolutePath()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private long getPersonsCount(String sessionToken) {
        PersonSearchCriteria personSearchCriteria = new PersonSearchCriteria();
        SearchResult personSearchResult = this.applicationServerApi.searchPersons(sessionToken, personSearchCriteria, new PersonFetchOptions());
        long personsCount = personSearchResult.getObjects().stream().filter(Person::isActive).count();
        return personsCount;
    }

    private static enum StatisticsKeys {
        SERVER_ID,
        SUBMISSION_TIMESTAMP,
        USERS_COUNT,
        OPENBIS_VERSION;

    }

    private static class JacksonObjectMapper {
        private static final JacksonObjectMapper jacksonObjectMapper = new JacksonObjectMapper();
        private final ObjectMapper objectMapper = new ObjectMapper();

        public static JacksonObjectMapper getInstance() {
            return jacksonObjectMapper;
        }

        private JacksonObjectMapper() {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.objectMapper.enableDefaultTyping();
        }

        public <T> T readValue(InputStream src, Class<T> valueType) throws IOException {
            return (T)this.objectMapper.readValue(src, valueType);
        }

        public <T> T readValue(InputStream src, TypeReference<T> typeRef) throws Exception {
            return (T)this.objectMapper.readValue(src, typeRef);
        }

        public byte[] writeValue(Object value) throws JsonProcessingException {
            return this.objectMapper.writeValueAsBytes(value);
        }
    }
}

