/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.AuthorizationGroup;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.fetchoptions.AuthorizationGroupFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.AuthorizationGroupPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractEntitySearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.search.ExperimentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.PersonSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.openbis.generic.server.task.Period;
import ch.systemsx.cisd.openbis.generic.server.task.UsageAndGroupsInfo;
import ch.systemsx.cisd.openbis.generic.server.task.UsageInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UsageGatherer {
    static final String UNNAMED_GROUP = "";
    private IApplicationServerInternalApi service;
    private Set<String> spacesToBeIgnored;

    public UsageGatherer(IApplicationServerInternalApi service, Set<String> spacesToBeIgnored) {
        this.service = service;
        this.spacesToBeIgnored = spacesToBeIgnored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageAndGroupsInfo gatherUsageAndGroups(Period period, List<String> groupsOrNull) {
        String sessionToken = this.service.loginAsSystem();
        try {
            Map<String, Map<String, UsageInfo>> usageByUsersAndSpaces = this.gatherUsageByUsersAndSpaces(sessionToken, period);
            Map<String, Set<String>> usersByGroup = this.gatherUsersByGroups(sessionToken, groupsOrNull);
            UsageAndGroupsInfo usageAndGroupsInfo = new UsageAndGroupsInfo(usageByUsersAndSpaces, usersByGroup);
            return usageAndGroupsInfo;
        }
        finally {
            this.service.logout(sessionToken);
        }
    }

    private Map<String, Map<String, UsageInfo>> gatherUsageByUsersAndSpaces(String sessionToken, Period period) {
        TreeMap<String, Map<String, UsageInfo>> usageByUsersAndSpaces = new TreeMap<String, Map<String, UsageInfo>>();
        PersonSearchCriteria searchCriteria = new PersonSearchCriteria();
        PersonFetchOptions fetchOptions = new PersonFetchOptions();
        for (Person user : this.service.searchPersons(sessionToken, searchCriteria, fetchOptions).getObjects()) {
            TreeMap usageBySpaces = new TreeMap();
            usageByUsersAndSpaces.put(user.getUserId(), usageBySpaces);
        }
        this.gatherNewExperimentUsage(sessionToken, usageByUsersAndSpaces, period);
        this.gatherNewSampleUsage(sessionToken, usageByUsersAndSpaces, period);
        this.gatherNewDataSetUsage(sessionToken, usageByUsersAndSpaces, period);
        return usageByUsersAndSpaces;
    }

    private Map<String, Set<String>> gatherUsersByGroups(String sessionToken, List<String> groupsOrNull) {
        TreeMap<String, Set<String>> usersByGroup = new TreeMap<String, Set<String>>();
        if (groupsOrNull != null) {
            List groupIds = groupsOrNull.stream().map(AuthorizationGroupPermId::new).collect(Collectors.toList());
            AuthorizationGroupFetchOptions groupFetchOptions = new AuthorizationGroupFetchOptions();
            groupFetchOptions.withUsers();
            for (AuthorizationGroup group : this.service.getAuthorizationGroups(sessionToken, groupIds, groupFetchOptions).values()) {
                TreeSet<String> userIds = new TreeSet<String>();
                for (Person user : group.getUsers()) {
                    userIds.add(user.getUserId());
                }
                usersByGroup.put(group.getCode(), userIds);
            }
        }
        return usersByGroup;
    }

    private void gatherNewExperimentUsage(String sessionToken, Map<String, Map<String, UsageInfo>> usageByUsersAndSpaces, Period period) {
        ExperimentSearchCriteria searchCriteria = new ExperimentSearchCriteria();
        this.setPeriod((AbstractEntitySearchCriteria<?>)searchCriteria, period);
        ExperimentFetchOptions fetchOptions = new ExperimentFetchOptions();
        fetchOptions.withProject().withSpace();
        fetchOptions.withRegistrator();
        List experiments = this.service.searchExperiments(sessionToken, searchCriteria, fetchOptions).getObjects();
        Function<Experiment, String> spaceExtractor = exp -> exp.getProject().getSpace().getCode();
        this.gatherUsage(usageByUsersAndSpaces, experiments, spaceExtractor, UsageInfo::addNewExperiment);
    }

    private void gatherNewSampleUsage(String sessionToken, Map<String, Map<String, UsageInfo>> usageByUsersAndSpaces, Period period) {
        SampleSearchCriteria searchCriteria = new SampleSearchCriteria();
        this.setPeriod((AbstractEntitySearchCriteria<?>)searchCriteria, period);
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withSpace();
        fetchOptions.withRegistrator();
        List samples = this.service.searchSamples(sessionToken, searchCriteria, fetchOptions).getObjects();
        Function<Sample, String> spaceExtractor = sample -> sample.getSpace().getCode();
        this.gatherUsage(usageByUsersAndSpaces, samples, spaceExtractor, UsageInfo::addNewSample);
    }

    private void gatherNewDataSetUsage(String sessionToken, Map<String, Map<String, UsageInfo>> usageByUsersAndSpaces, Period period) {
        DataSetSearchCriteria searchCriteria = new DataSetSearchCriteria();
        this.setPeriod((AbstractEntitySearchCriteria<?>)searchCriteria, period);
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withRegistrator();
        SampleFetchOptions sampleFetchOptions = fetchOptions.withSample();
        sampleFetchOptions.withSpace();
        ExperimentFetchOptions experimentFetchOptions = fetchOptions.withExperiment();
        experimentFetchOptions.withProject().withSpace();
        List dataSets = this.service.searchDataSets(sessionToken, searchCriteria, fetchOptions).getObjects();
        Function<DataSet, String> spaceExtractor = new Function<DataSet, String>(){

            @Override
            public String apply(DataSet dataSet) {
                Experiment experiment = dataSet.getExperiment();
                if (experiment != null) {
                    return experiment.getProject().getSpace().getCode();
                }
                return dataSet.getSample().getSpace().getCode();
            }
        };
        this.gatherUsage(usageByUsersAndSpaces, dataSets, spaceExtractor, UsageInfo::addNewDataSet);
    }

    private <T extends IRegistratorHolder> void gatherUsage(Map<String, Map<String, UsageInfo>> usageByUsersAndSpaces, List<T> entities, Function<T, String> spaceExtractor, Consumer<UsageInfo> consumer) {
        for (IRegistratorHolder entity : entities) {
            String space;
            String userId = entity.getRegistrator().getUserId();
            Map<String, UsageInfo> usageBySpaces = usageByUsersAndSpaces.get(userId);
            if (usageBySpaces == null || this.spacesToBeIgnored.contains(space = spaceExtractor.apply(entity))) continue;
            UsageInfo usageInfo = usageBySpaces.get(space);
            if (usageInfo == null) {
                usageInfo = new UsageInfo();
                usageBySpaces.put(space, usageInfo);
            }
            consumer.accept(usageInfo);
        }
    }

    private void setPeriod(AbstractEntitySearchCriteria<?> searchCriteria, Period period) {
        searchCriteria.withRegistrationDate().thatIsLaterThanOrEqualTo(period.getFrom());
        searchCriteria.withRegistrationDate().thatIsEarlierThanOrEqualTo(period.getUntil());
    }
}

