/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.maintenance.INextTimestampProvider;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.task.AbstractMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.Period;
import ch.systemsx.cisd.openbis.generic.server.task.PeriodType;
import ch.systemsx.cisd.openbis.generic.server.task.UsageAndGroupsInfo;
import ch.systemsx.cisd.openbis.generic.server.task.UsageGatherer;
import ch.systemsx.cisd.openbis.generic.server.task.UsageInfo;
import ch.systemsx.cisd.openbis.generic.server.task.UserGroup;
import ch.systemsx.cisd.openbis.generic.server.task.UserManagerConfig;
import ch.systemsx.cisd.openbis.generic.server.util.PluginUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang3.StringUtils;

public class UsageReportingTask
extends AbstractMaintenanceTask {
    static final String USER_REPORTING_KEY = "user-reporting-type";
    static final String COUNT_ALL_ENTITIES_KEY = "count-all-entities";
    static final String DELIM = "\t";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_STAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private PeriodType periodType;
    private List<EMailAddress> eMailAddresses;
    private UserReportingType userReportingType;
    private boolean countAllEntities;
    private Set<String> spacesToBeIgnored;

    public UsageReportingTask() {
        super(false);
    }

    @Override
    protected void setUpSpecific(Properties properties) {
        long interval;
        INextTimestampProvider nextTimestampProvider = this.parameters.getNextTimestampProvider();
        if (nextTimestampProvider != null) {
            Date next = nextTimestampProvider.getNextTimestamp(this.getActualTimeStamp());
            interval = nextTimestampProvider.getNextTimestamp(next).getTime() - next.getTime();
        } else {
            interval = this.parameters.getIntervalSeconds() * 1000L;
        }
        this.periodType = PeriodType.getBestType(interval);
        this.eMailAddresses = PluginUtils.getEMailAddresses(properties, ",");
        this.spacesToBeIgnored = new HashSet<String>(PropertyUtils.getList((Properties)properties, (String)"spaces-to-be-ignored"));
        this.userReportingType = UserReportingType.valueOf(properties.getProperty(USER_REPORTING_KEY, UserReportingType.ALL.name()));
        this.countAllEntities = PropertyUtils.getBoolean((Properties)properties, (String)COUNT_ALL_ENTITIES_KEY, (boolean)false);
    }

    public void execute() {
        List<String> groups = this.getGroups();
        Date actualTimeStamp = this.getActualTimeStamp();
        Period period = this.periodType.getPeriod(actualTimeStamp);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String fromDateString = dateFormat.format(period.getFrom());
        String untilDateString = dateFormat.format(period.getUntil());
        this.operationLog.info((Object)("Gather usage information for the period from " + fromDateString + " until " + untilDateString));
        UsageAndGroupsInfo usageAndGroupsInfo = this.gatherUsageAndGroups(groups, period);
        UsageAndGroupsInfo usageAndGroupsInfoForAllEntities = null;
        if (this.countAllEntities) {
            usageAndGroupsInfoForAllEntities = this.gatherUsageAndGroups(groups, new Period(new Date(0L), period.getUntil()));
        }
        String report = this.createReport(usageAndGroupsInfo, usageAndGroupsInfoForAllEntities, period, groups);
        this.sendReport(fromDateString, untilDateString, report);
        this.operationLog.info((Object)"Usage report created and sent.");
    }

    protected Date getActualTimeStamp() {
        return new Date();
    }

    protected UsageAndGroupsInfo gatherUsageAndGroups(List<String> groups, Period period) {
        UsageGatherer gatherer = new UsageGatherer(CommonServiceProvider.getApplicationServerApi(), this.spacesToBeIgnored);
        return gatherer.gatherUsageAndGroups(period, groups);
    }

    protected IMailClient getMailClient() {
        return CommonServiceProvider.createEMailClient();
    }

    private List<String> getGroups() {
        UserManagerConfig config = this.readGroupDefinitions(null);
        if (config == null) {
            return null;
        }
        return config.getGroups().stream().map(UserGroup::getKey).collect(Collectors.toList());
    }

    private void sendReport(String fromDateString, String untilDateString, String report) {
        IMailClient mailClient = this.getMailClient();
        String subject = "Usage report for the period from " + fromDateString + " until " + untilDateString;
        String fileName = "usage_report_" + fromDateString + "_" + untilDateString + ".tsv";
        try {
            for (EMailAddress eMailAddress : this.eMailAddresses) {
                mailClient.sendEmailMessageWithAttachment(subject, "The usage report can be found in the attached TSV file.", fileName, new DataHandler((DataSource)new ByteArrayDataSource(report, "text/plain")), null, null, new EMailAddress[]{eMailAddress});
            }
        }
        catch (IOException e) {
            this.notificationLog.error((Object)("Couldn't sent usage report:" + e));
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    private String createReport(UsageAndGroupsInfo usageAndGroupsInfo, UsageAndGroupsInfo usageAndGroupsInfoForAllEntitiesOrNull, Period period, List<String> groups) {
        StringBuilder builder = new StringBuilder();
        builder.append("period start\tperiod end\tgroup name\tnumber of users\tidle users\tnumber of new collections\tnumber of new objects\tnumber of new data sets");
        if (usageAndGroupsInfoForAllEntitiesOrNull != null) {
            builder.append(DELIM).append("total number of entities");
        }
        builder.append("\n");
        Map<String, GroupInfo> groupInfos = this.initializeGroupInfos(usageAndGroupsInfo);
        final TreeMap<String, GroupInfo> individualInfos = new TreeMap<String, GroupInfo>();
        for (String user : usageAndGroupsInfo.getUsageByUsersAndSpaces().keySet()) {
            individualInfos.put(user, new GroupInfo(Arrays.asList(user)));
        }
        this.handleUsageAndGroupInfos(usageAndGroupsInfo, groupInfos, individualInfos, new IUsageInfoHandler(){

            @Override
            public void handleUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo, boolean groupAction) {
                UsageReportingTask.this.userReportingType.handleUsageInfo((GroupInfo)individualInfos.get(user), user, usageInfo, groupAction);
            }

            @Override
            public void handleGroupUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo) {
                groupInfo.handle(user, usageInfo);
            }
        });
        if (usageAndGroupsInfoForAllEntitiesOrNull != null) {
            this.handleUsageAndGroupInfos(usageAndGroupsInfoForAllEntitiesOrNull, groupInfos, individualInfos, new IUsageInfoHandler(){

                @Override
                public void handleUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo, boolean groupAction) {
                    groupInfo.countEntities(usageInfo);
                }

                @Override
                public void handleGroupUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo) {
                    groupInfo.countEntities(usageInfo);
                }
            });
        }
        this.addInfos(builder, period, groupInfos, true);
        this.addInfos(builder, period, individualInfos, false);
        return builder.toString();
    }

    private void handleUsageAndGroupInfos(UsageAndGroupsInfo usageAndGroupsInfo, Map<String, GroupInfo> groupInfos, Map<String, GroupInfo> individualInfos, IUsageInfoHandler handler) {
        Map<String, Set<String>> usersByGroups = usageAndGroupsInfo.getUsersByGroups();
        for (Map.Entry<String, Map<String, UsageInfo>> entry : usageAndGroupsInfo.getUsageByUsersAndSpaces().entrySet()) {
            String user = entry.getKey();
            for (Map.Entry<String, UsageInfo> entry2 : entry.getValue().entrySet()) {
                String space = entry2.getKey();
                UsageInfo usageInfo = entry2.getValue();
                handler.handleGroupUsageInfo(groupInfos.get(""), user, usageInfo);
                String[] spaceParts = space.split("_");
                boolean groupAction = false;
                if (spaceParts.length > 1) {
                    String group = spaceParts[0];
                    GroupInfo groupInfo = groupInfos.get(group);
                    Set<String> groupUsers = usersByGroups.get(group);
                    if (groupInfo != null && groupUsers != null && groupUsers.contains(user)) {
                        handler.handleGroupUsageInfo(groupInfo, user, usageInfo);
                        groupAction = true;
                    }
                }
                handler.handleUsageInfo(individualInfos.get(user), user, usageInfo, groupAction);
            }
        }
    }

    private Map<String, GroupInfo> initializeGroupInfos(UsageAndGroupsInfo usageAndGroupsInfo) {
        TreeMap<String, GroupInfo> groupInfos = new TreeMap<String, GroupInfo>();
        for (Map.Entry<String, Set<String>> entry : usageAndGroupsInfo.getUsersByGroups().entrySet()) {
            groupInfos.put(entry.getKey(), new GroupInfo((Collection<String>)entry.getValue()));
        }
        groupInfos.put("", new GroupInfo(usageAndGroupsInfo.getUsageByUsersAndSpaces().keySet()));
        return groupInfos;
    }

    private void addInfos(StringBuilder builder, Period period, Map<String, GroupInfo> infos, boolean showIdle) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_STAMP_FORMAT);
        String fromDate = dateFormat.format(period.getFrom());
        String untilDate = dateFormat.format(period.getUntil());
        Set<Map.Entry<String, GroupInfo>> entrySet = infos.entrySet();
        for (Map.Entry<String, GroupInfo> entry : entrySet) {
            GroupInfo info = entry.getValue();
            Set<String> idleUsers = info.getIdleUsers();
            int numberOfUsers = info.getNumberOfUsers();
            if (!showIdle && idleUsers.size() >= numberOfUsers) continue;
            builder.append(fromDate).append(DELIM).append(untilDate).append(DELIM).append(entry.getKey()).append(DELIM);
            builder.append(numberOfUsers).append(DELIM);
            builder.append(StringUtils.join(idleUsers, (char)' ')).append(DELIM);
            builder.append(info.getNumberOfNewExperiments()).append(DELIM);
            builder.append(info.getNumberOfNewSamples()).append(DELIM);
            builder.append(info.getNumberOfNewDataSets());
            if (this.countAllEntities) {
                builder.append(DELIM).append(info.getNumberOfEntities());
            }
            builder.append("\n");
        }
    }

    private static final class GroupInfo {
        private Set<String> allUsers = new HashSet<String>();
        private Set<String> activeUsers = new HashSet<String>();
        private int numberOfNewExperiments;
        private int numberOfNewSamples;
        private int numberOfNewDataSets;
        private int numberOfEntities;

        public GroupInfo(Collection<String> users) {
            this.allUsers.addAll(users);
        }

        void handle(String user, UsageInfo usageInfo) {
            if (!usageInfo.isIdle()) {
                this.activeUsers.add(user);
            }
            this.numberOfNewExperiments += usageInfo.getNumberOfNewExperiments();
            this.numberOfNewSamples += usageInfo.getNumberOfNewSamples();
            this.numberOfNewDataSets += usageInfo.getNumberOfNewDataSets();
        }

        void countEntities(UsageInfo usageInfo) {
            this.numberOfEntities += usageInfo.getNumberOfNewDataSets();
            this.numberOfEntities += usageInfo.getNumberOfNewExperiments();
            this.numberOfEntities += usageInfo.getNumberOfNewSamples();
        }

        int getNumberOfUsers() {
            return this.allUsers.size();
        }

        Set<String> getIdleUsers() {
            TreeSet<String> idleUsers = new TreeSet<String>(this.allUsers);
            idleUsers.removeAll(this.activeUsers);
            return idleUsers;
        }

        int getNumberOfNewExperiments() {
            return this.numberOfNewExperiments;
        }

        int getNumberOfNewSamples() {
            return this.numberOfNewSamples;
        }

        int getNumberOfNewDataSets() {
            return this.numberOfNewDataSets;
        }

        int getNumberOfEntities() {
            return this.numberOfEntities;
        }
    }

    static enum UserReportingType {
        NONE,
        OUTSIDE_GROUP_ONLY{

            @Override
            void handleUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo, boolean groupAction) {
                if (!groupAction) {
                    groupInfo.handle(user, usageInfo);
                }
            }
        }
        ,
        ALL{

            @Override
            void handleUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo, boolean groupAction) {
                groupInfo.handle(user, usageInfo);
            }
        };


        void handleUsageInfo(GroupInfo groupInfo, String user, UsageInfo usageInfo, boolean groupAction) {
        }
    }

    public static interface IUsageInfoHandler {
        public void handleUsageInfo(GroupInfo var1, String var2, UsageInfo var3, boolean var4);

        public void handleGroupUsageInfo(GroupInfo var1, String var2, UsageInfo var3);
    }
}

