/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.ldap.LDAPAuthenticationService;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.BufferedAppender;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.task.AbstractMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.UserGroup;
import ch.systemsx.cisd.openbis.generic.server.task.UserManager;
import ch.systemsx.cisd.openbis.generic.server.task.UserManagerConfig;
import ch.systemsx.cisd.openbis.generic.server.task.UserManagerReport;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;

public class UserManagementMaintenanceTask
extends AbstractMaintenanceTask {
    static final String DEACTIVATE_UNKOWN_USERS_PROPERTY = "deactivate-unknown-users";
    static final String AUDIT_LOG_FILE_PATH_PROPERTY = "audit-log-file-path";
    static final String DEFAULT_AUDIT_LOG_FILE_PATH = "logs/user-management-audit_log.txt";
    static final String SHARES_MAPPING_FILE_PATH_PROPERTY = "shares-mapping-file-path";
    static final String LDAP_FILTER_KEY_PROPERTY = "filter-key";
    static final String DEFAULT_LDAP_FILTER_KEY = "ou";
    static final String LDAP_GROUP_QUERY_TEMPLATE = "ldap-group-query-template";
    private File auditLogFile;
    private LDAPAuthenticationService ldapService;
    private File shareIdsMappingFile;
    private String filterKey;
    private boolean deactivateUnknownUsers;
    private BufferedAppender bufferedAppender;
    private int executionId;
    private final Map<Integer, UserManagerReport> reportsById = new HashMap<Integer, UserManagerReport>();
    private String groupQueryTemplateOrNull;

    public UserManagementMaintenanceTask() {
        super(true);
        this.bufferedAppender = new BufferedAppender("%d{HH:mm:ss,SSS} %-5p [%t] %c - %m%n", Level.INFO, "OPERATION.UserManagementMaintenanceTask");
    }

    @Override
    protected void setUpSpecific(Properties properties) {
        this.deactivateUnknownUsers = PropertyUtils.getBoolean((Properties)properties, (String)DEACTIVATE_UNKOWN_USERS_PROPERTY, (boolean)true);
        this.auditLogFile = new File(properties.getProperty(AUDIT_LOG_FILE_PATH_PROPERTY, DEFAULT_AUDIT_LOG_FILE_PATH));
        if (this.auditLogFile.isDirectory()) {
            throw new ConfigurationFailureException("Audit log file '" + this.auditLogFile.getAbsolutePath() + "' is a directory.");
        }
        this.ldapService = this.getLdapAuthenticationService();
        this.filterKey = properties.getProperty(LDAP_FILTER_KEY_PROPERTY, DEFAULT_LDAP_FILTER_KEY);
        this.groupQueryTemplateOrNull = properties.getProperty(LDAP_GROUP_QUERY_TEMPLATE);
        String shareIdsMappingFilePath = properties.getProperty(SHARES_MAPPING_FILE_PATH_PROPERTY);
        if (shareIdsMappingFilePath != null) {
            this.shareIdsMappingFile = new File(shareIdsMappingFilePath);
            if (this.shareIdsMappingFile.isDirectory()) {
                throw new ConfigurationFailureException("Share ids mapping file '" + this.shareIdsMappingFile.getAbsolutePath() + "' is a directory.");
            }
        }
    }

    public void execute() {
        UserManagerReport report = this.createUserManagerReport();
        this.execute(report);
    }

    public int executeAsync() {
        ++this.executionId;
        final UserManagerReport report = this.createUserManagerReport();
        this.reportsById.put(this.executionId, report);
        this.operationLog.info((Object)(this.reportsById.size() + " tasks are running."));
        new Thread(new Runnable(){

            @Override
            public void run() {
                UserManagementMaintenanceTask.this.execute(report);
            }
        }).start();
        return this.executionId;
    }

    public UserManagerReport getReportById(int executionId) {
        return this.reportsById.get(executionId);
    }

    public void removeReport(int executionId) {
        this.reportsById.remove(executionId);
    }

    public synchronized void execute(UserManagerReport report) {
        this.bufferedAppender.resetLogContent();
        UserManagerConfig config = this.readGroupDefinitions(report);
        if (config == null || config.getGroups() == null) {
            return;
        }
        this.operationLog.info((Object)("manage " + config.getGroups().size() + " groups"));
        Log4jSimpleLogger logger = new Log4jSimpleLogger(this.operationLog);
        HashSet<String> knownUsers = new HashSet<String>();
        UserManager userManager = this.createUserManager(config, logger, report);
        for (UserGroup group : config.getGroups()) {
            this.addGroup(userManager, group);
            if (group.getUsers() == null) continue;
            knownUsers.addAll(group.getUsers());
        }
        userManager.manage(knownUsers);
        this.handleReport(report);
        this.operationLog.info((Object)"finished");
    }

    private void addGroup(UserManager userManager, UserGroup group) {
        List<String> ldapGroupKeys;
        List<String> shareIds;
        String key = group.getKey();
        if (this.shareIdsMappingFile != null && ((shareIds = group.getShareIds()) == null || shareIds.isEmpty())) {
            this.operationLog.warn((Object)("Group '" + key + "' skipped because no shareIds specified."));
            return;
        }
        TreeMap<String, Principal> principalsByUserId = new TreeMap<String, Principal>();
        List<String> users = group.getUsers();
        if (users != null && !users.isEmpty()) {
            for (String user : users) {
                principalsByUserId.put(user, new Principal(user, "", "", ""));
            }
        }
        if ((ldapGroupKeys = group.getLdapGroupKeys()) != null && !ldapGroupKeys.isEmpty()) {
            for (String ldapGroupKey : ldapGroupKeys) {
                if (StringUtils.isBlank((CharSequence)ldapGroupKey)) {
                    this.operationLog.warn((Object)("Group '" + key + "' has empty ldapGroupKey."));
                    continue;
                }
                try {
                    List<Principal> principals = this.getUsersOfGroup(ldapGroupKey);
                    if (group.isEnabled() && principals.isEmpty()) {
                        this.operationLog.warn((Object)("Group '" + key + "' has no users found for ldapGroupKey '" + ldapGroupKey + "'."));
                    }
                    for (Principal principal : principals) {
                        principalsByUserId.put(principal.getUserId(), principal);
                    }
                }
                catch (Throwable e) {
                    this.operationLog.error((Object)("Group '" + key + "' leads to error for ldapGroupKey '" + ldapGroupKey + "': " + e), e);
                }
            }
        }
        if (principalsByUserId.isEmpty()) {
            this.operationLog.warn((Object)("Group '" + key + "' skipped because no users specified or found."));
        } else {
            userManager.addGroup(group, principalsByUserId);
        }
    }

    private void handleReport(UserManagerReport report) {
        String auditLog;
        String errorReport = report.getErrorReport();
        if (StringUtils.isNotBlank((CharSequence)errorReport)) {
            this.notificationLog.error((Object)("User management failed for the following reason(s):\n\n" + errorReport));
        }
        if (StringUtils.isNotBlank((CharSequence)(auditLog = report.getAuditLog()))) {
            FileUtilities.appendToFile((File)this.auditLogFile, (String)auditLog, (boolean)true);
        }
    }

    protected List<Principal> getUsersOfGroup(String ldapGroupKey) {
        if (!this.ldapService.isConfigured()) {
            throw new ConfigurationFailureException("There is no LDAP authentication service configured. At least 'ldap.server.url', 'ldap.security.principal.distinguished.name', 'ldap.security.principal.password' have to be specified in 'service.properties'.");
        }
        String query = this.groupQueryTemplateOrNull == null ? null : String.format(this.groupQueryTemplateOrNull, ldapGroupKey);
        return this.ldapService.listPrincipalsByKeyValueOrQuery(this.filterKey, ldapGroupKey, query);
    }

    protected LDAPAuthenticationService getLdapAuthenticationService() {
        return (LDAPAuthenticationService)CommonServiceProvider.tryToGetBean("ldap-authentication-service");
    }

    protected UserManagerReport createUserManagerReport() {
        return new UserManagerReport((ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER, this.bufferedAppender);
    }

    private UserManager createUserManager(UserManagerConfig config, Log4jSimpleLogger logger, UserManagerReport report) {
        UserManager userManager = this.createUserManager(logger, report);
        userManager.setGlobalSpaces(config.getGlobalSpaces());
        try {
            userManager.setCommon(config.getCommonSpaces(), config.getCommonSamples(), config.getCommonExperiments());
        }
        catch (ConfigurationFailureException e) {
            this.notificationLog.error((Object)e.getMessage());
        }
        return userManager;
    }

    protected UserManager createUserManager(Log4jSimpleLogger logger, UserManagerReport report) {
        IAuthenticationService authenticationService = (IAuthenticationService)CommonServiceProvider.tryToGetBean("authentication-service");
        UserManager userManager = new UserManager(authenticationService, CommonServiceProvider.getApplicationServerApi(), this.shareIdsMappingFile, (ISimpleLogger)logger, report);
        userManager.setDeactivateUnknwonUsers(this.deactivateUnknownUsers);
        return userManager;
    }
}

