/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.AuthorizationGroup;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.create.AuthorizationGroupCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.create.CreateAuthorizationGroupsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.fetchoptions.AuthorizationGroupFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.AuthorizationGroupPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.IAuthorizationGroupId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.search.AuthorizationGroupSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.update.AuthorizationGroupUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.update.UpdateAuthorizationGroupsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.create.CreateExperimentsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.create.ExperimentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.IOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.operation.SynchronousOperationExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.create.CreatePersonsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.create.PersonCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.IPersonId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.PersonSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.update.PersonUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.update.UpdatePersonsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.create.CreateProjectsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.create.ProjectCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.Role;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleLevel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.create.CreateRoleAssignmentsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.create.RoleAssignmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.delete.DeleteRoleAssignmentsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.delete.RoleAssignmentDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.id.IRoleAssignmentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.CreateSamplesOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.create.CreateSpacesOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.create.SpaceCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.generic.server.task.UserGroup;
import ch.systemsx.cisd.openbis.generic.server.task.UserManagerReport;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class UserManager {
    private static final String GLOBAL_AUTHORIZATION_GROUP_CODE = "ALL_GROUPS";
    private static final AuthorizationGroupPermId GLOBAL_AUTHORIZATION_GROUP_ID = new AuthorizationGroupPermId("ALL_GROUPS");
    private final IAuthenticationService authenticationService;
    private final IApplicationServerInternalApi service;
    private final ISimpleLogger logger;
    private final UserManagerReport report;
    private final Map<String, UserInfo> userInfosByUserId = new TreeMap<String, UserInfo>();
    private final Map<String, Map<String, Principal>> usersByGroupCode = new LinkedHashMap<String, Map<String, Principal>>();
    private final Map<String, UserGroup> groupsByCode = new LinkedHashMap<String, UserGroup>();
    private List<String> globalSpaces = new ArrayList<String>();
    private Map<Role, List<String>> commonSpacesByRole = new HashMap<Role, List<String>>();
    private Map<String, String> commonSamples = new HashMap<String, String>();
    private Map<String, String> commonExperiments;
    private Map<String, HomeSpaceRequest> requestedHomeSpaceByUserId = new TreeMap<String, HomeSpaceRequest>();
    private File shareIdsMappingFileOrNull;
    private List<MappingAttributes> mappingAttributesList = new ArrayList<MappingAttributes>();
    private boolean deactivateUnknownUsers;

    public UserManager(IAuthenticationService authenticationService, IApplicationServerInternalApi service, File shareIdsMappingFileOrNull, ISimpleLogger logger, UserManagerReport report) {
        this.authenticationService = authenticationService;
        this.service = service;
        this.shareIdsMappingFileOrNull = shareIdsMappingFileOrNull;
        this.logger = logger;
        this.report = report;
    }

    public void setGlobalSpaces(List<String> globalSpaces) {
        this.globalSpaces = globalSpaces;
    }

    public void setCommon(Map<Role, List<String>> commonSpacesByRole, Map<String, String> commonSamples, Map<String, String> commonExperiments) {
        this.commonSpacesByRole = commonSpacesByRole;
        this.commonSamples = commonSamples;
        this.commonExperiments = commonExperiments;
        HashSet<String> commonSpaces = new HashSet<String>();
        commonSpacesByRole.values().forEach(spaces -> commonSpaces.addAll((Collection<String>)spaces));
        this.checkIdentifierTemplates(commonSamples, commonSpaces, "sample", "<common space code>/<common sample code>");
        this.checkIdentifierTemplates(commonExperiments, commonSpaces, "experiment", "<common space code>/<common project code>/<common experiment code>");
    }

    private void checkIdentifierTemplates(Map<String, String> commonEntities, Set<String> commonSpaces, String entityKind, String templateSchema) {
        for (String identifierTemplate : commonEntities.keySet()) {
            String[] parts = identifierTemplate.split("/");
            if (!commonSpaces.contains(parts[0])) {
                throw this.createConfigException(identifierTemplate, templateSchema, "No common space for common " + entityKind);
            }
            if (parts.length == templateSchema.split("/").length) continue;
            throw this.createConfigException(identifierTemplate, templateSchema, "");
        }
    }

    private ConfigurationFailureException createConfigException(String identifierTemplate, String templateSchema, String message) {
        return new ConfigurationFailureException("Identifier template '" + identifierTemplate + "' is invalid" + (StringUtils.isBlank((CharSequence)message) ? ". " : " (reason: " + message + "). ") + "Template schema: " + templateSchema);
    }

    public void setDeactivateUnknwonUsers(boolean deactivateUnknownUsers) {
        this.deactivateUnknownUsers = deactivateUnknownUsers;
    }

    public void addGroup(UserGroup group, Map<String, Principal> principalsByUserId) {
        String groupCode = group.getKey().toUpperCase();
        this.usersByGroupCode.put(groupCode, group.isEnabled() ? principalsByUserId : new HashMap());
        this.groupsByCode.put(groupCode, group);
        this.mappingAttributesList.add(new MappingAttributes(groupCode, group.getShareIds()));
        Set<String> admins = this.asSet(group.getAdmins());
        if (group.isEnabled()) {
            for (Principal principal : principalsByUserId.values()) {
                String userId = this.getUserId(principal, group.isUseEmailAsUserId());
                UserInfo userInfo = this.userInfosByUserId.get(userId);
                if (userInfo == null) {
                    userInfo = new UserInfo(principal);
                    this.userInfosByUserId.put(userId, userInfo);
                }
                userInfo.addGroupInfo(new GroupInfo(groupCode, admins.contains(userId)));
            }
        }
        this.logger.log(LogLevel.INFO, principalsByUserId.size() + " users for " + (group.isEnabled() ? "" : "disabled ") + "group " + groupCode);
    }

    public void manage(Set<String> knownUsers) {
        try {
            String sessionToken = this.service.loginAsSystem();
            this.updateMappingFile();
            this.manageGlobalSpaces(sessionToken, this.report);
            if (this.deactivateUnknownUsers) {
                this.revokeUnknownUsers(sessionToken, knownUsers, this.report);
            }
            CurrentState currentState = this.loadCurrentState(sessionToken, this.service);
            for (Map.Entry<String, Map<String, Principal>> entry : this.usersByGroupCode.entrySet()) {
                String groupCode = entry.getKey();
                Map<String, Principal> users = entry.getValue();
                this.manageGroup(sessionToken, groupCode, users, currentState, this.report);
            }
            this.updateHomeSpaces(sessionToken, currentState, this.report);
            this.service.logout(sessionToken);
        }
        catch (Throwable e) {
            this.report.addErrorMessage("Error: " + e.toString());
            this.logger.log(LogLevel.ERROR, "", e);
        }
    }

    private void updateMappingFile() {
        block5: {
            if (this.shareIdsMappingFileOrNull == null || this.mappingAttributesList.isEmpty()) break block5;
            File parentFile = this.shareIdsMappingFileOrNull.getParentFile();
            parentFile.mkdirs();
            File newFile = new File(parentFile, this.shareIdsMappingFileOrNull.getName() + ".new");
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(newFile);
                printWriter.println("Identifier\tShare IDs\tArchive Folder");
                for (MappingAttributes attributes : this.mappingAttributesList) {
                    CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
                    List<String> shareIds = attributes.getShareIds();
                    if (shareIds == null || shareIds.isEmpty()) continue;
                    shareIds.forEach(id -> builder.append(id));
                    printWriter.println(String.format("/%s_.*\t%s\t", attributes.getGroupCode(), builder.toString()));
                }
            }
            catch (IOException e) {
                try {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(printWriter);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)printWriter);
            newFile.renameTo(this.shareIdsMappingFileOrNull);
        }
    }

    private void updateHomeSpaces(String sessionToken, CurrentState currentState, UserManagerReport report) {
        ArrayList<PersonUpdate> updates = new ArrayList<PersonUpdate>();
        for (Map.Entry<String, HomeSpaceRequest> entry : this.requestedHomeSpaceByUserId.entrySet()) {
            String userId = entry.getKey();
            HomeSpaceRequest request = entry.getValue();
            SpacePermId requestedHomeSpace = request.getHomeSpace();
            if (requestedHomeSpace == null) continue;
            updates.add(this.createPersonUpdate(userId, requestedHomeSpace, report));
        }
        if (!updates.isEmpty()) {
            this.service.updatePersons(sessionToken, updates);
        }
    }

    private PersonUpdate createPersonUpdate(String userId, SpacePermId spacePermId, UserManagerReport report) {
        PersonPermId personId = new PersonPermId(userId);
        PersonUpdate personUpdate = new PersonUpdate();
        personUpdate.setUserId((IPersonId)personId);
        personUpdate.setSpaceId((ISpaceId)spacePermId);
        report.assignHomeSpace(userId, (ISpaceId)spacePermId);
        return personUpdate;
    }

    private void manageGlobalSpaces(String sessionToken, UserManagerReport report) {
        if (this.globalSpaces != null && !this.globalSpaces.isEmpty()) {
            this.createGlobalSpaces(sessionToken, report);
            Set<String> knownGlobalSpaces = this.createGlobalGroupAndGetKnownSpaces(sessionToken, GLOBAL_AUTHORIZATION_GROUP_ID, report);
            this.createGlobalRoleAssignments(sessionToken, GLOBAL_AUTHORIZATION_GROUP_ID, knownGlobalSpaces, report);
        }
    }

    private void createGlobalSpaces(String sessionToken, UserManagerReport report) {
        List spaceIds = this.globalSpaces.stream().map(SpacePermId::new).collect(Collectors.toList());
        Set knownSpaces = this.service.getSpaces(sessionToken, spaceIds, new SpaceFetchOptions()).keySet();
        ArrayList<SpaceCreation> spaceCreations = new ArrayList<SpaceCreation>();
        for (SpacePermId spaceId : spaceIds) {
            if (knownSpaces.contains(spaceId)) continue;
            SpaceCreation spaceCreation = new SpaceCreation();
            spaceCreation.setCode(spaceId.getPermId());
            spaceCreations.add(spaceCreation);
        }
        if (!spaceCreations.isEmpty()) {
            this.service.createSpaces(sessionToken, spaceCreations);
            report.addSpaces(spaceCreations);
        }
    }

    private Set<String> createGlobalGroupAndGetKnownSpaces(String sessionToken, AuthorizationGroupPermId groupId, UserManagerReport report) {
        AuthorizationGroupFetchOptions fetchOptions = new AuthorizationGroupFetchOptions();
        fetchOptions.withRoleAssignments().withSpace();
        AuthorizationGroup group = (AuthorizationGroup)this.service.getAuthorizationGroups(sessionToken, Arrays.asList(groupId), fetchOptions).get(groupId);
        TreeSet<String> knownGlobalSpaces = new TreeSet<String>();
        if (group == null) {
            AuthorizationGroupCreation groupCreation = new AuthorizationGroupCreation();
            groupCreation.setCode(GLOBAL_AUTHORIZATION_GROUP_CODE);
            groupCreation.setDescription("Authorization group for all users of all groups");
            this.service.createAuthorizationGroups(sessionToken, Arrays.asList(groupCreation));
            report.addGroup(GLOBAL_AUTHORIZATION_GROUP_CODE);
        } else {
            for (RoleAssignment roleAssignment : group.getRoleAssignments()) {
                if (!RoleLevel.SPACE.equals((Object)roleAssignment.getRoleLevel()) || !Role.OBSERVER.equals((Object)roleAssignment.getRole())) continue;
                knownGlobalSpaces.add(roleAssignment.getSpace().getCode());
            }
        }
        return knownGlobalSpaces;
    }

    private void createGlobalRoleAssignments(String sessionToken, AuthorizationGroupPermId groupId, Set<String> knownGlobalSpaces, UserManagerReport report) {
        ArrayList<RoleAssignmentCreation> assignmentCreations = new ArrayList<RoleAssignmentCreation>();
        for (String spaceCode : this.globalSpaces) {
            if (knownGlobalSpaces.contains(spaceCode)) continue;
            RoleAssignmentCreation assignmentCreation = new RoleAssignmentCreation();
            assignmentCreation.setAuthorizationGroupId((IAuthorizationGroupId)groupId);
            assignmentCreation.setRole(Role.OBSERVER);
            SpacePermId spaceId = new SpacePermId(spaceCode);
            assignmentCreation.setSpaceId((ISpaceId)spaceId);
            assignmentCreations.add(assignmentCreation);
            report.assignRoleTo(groupId, assignmentCreation.getRole(), (ISpaceId)spaceId);
        }
        if (!assignmentCreations.isEmpty()) {
            this.service.createRoleAssignments(sessionToken, assignmentCreations);
        }
    }

    private void revokeUnknownUsers(String sessionToken, Set<String> knownUsers, UserManagerReport report) {
        ArrayList<PersonUpdate> updates = new ArrayList<PersonUpdate>();
        PersonSearchCriteria searchCriteria = new PersonSearchCriteria();
        PersonFetchOptions fetchOptions = new PersonFetchOptions();
        fetchOptions.withRegistrator();
        List persons = this.service.searchPersons(sessionToken, searchCriteria, fetchOptions).getObjects();
        for (Person person : persons) {
            if (!person.isActive().booleanValue() || person.getRegistrator() == null || this.isKnownUser(knownUsers, person)) continue;
            PersonUpdate update = new PersonUpdate();
            update.setUserId((IPersonId)person.getPermId());
            update.deactivate();
            updates.add(update);
            report.deactivateUser(person.getUserId());
        }
        if (!updates.isEmpty()) {
            this.service.updatePersons(sessionToken, updates);
        }
    }

    private boolean isKnownUser(Set<String> knownUsers, Person person) {
        String userId = person.getUserId();
        if (knownUsers.contains(userId)) {
            return true;
        }
        try {
            UserInfo userInfo = this.userInfosByUserId.get(userId);
            if (userInfo != null) {
                userId = userInfo.principal.getUserId();
            }
            this.authenticationService.getPrincipal(userId);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private CurrentState loadCurrentState(String sessionToken, IApplicationServerInternalApi service) {
        List<AuthorizationGroup> authorizationGroups = this.getAllAuthorizationGroups(sessionToken, service);
        List<Person> users = this.getAllUsers(sessionToken, service);
        List<Space> spaces = this.getAllSpaces(sessionToken, service);
        List<AuthorizationGroupPermId> ids = Arrays.asList(GLOBAL_AUTHORIZATION_GROUP_ID);
        AuthorizationGroupFetchOptions fetchOptions = new AuthorizationGroupFetchOptions();
        fetchOptions.withRoleAssignments().withSpace();
        fetchOptions.withUsers();
        AuthorizationGroup group = (AuthorizationGroup)service.getAuthorizationGroups(sessionToken, ids, fetchOptions).get(GLOBAL_AUTHORIZATION_GROUP_ID);
        return new CurrentState(authorizationGroups, group, spaces, users);
    }

    private List<AuthorizationGroup> getAllAuthorizationGroups(String sessionToken, IApplicationServerInternalApi service) {
        AuthorizationGroupSearchCriteria searchCriteria = new AuthorizationGroupSearchCriteria();
        AuthorizationGroupFetchOptions fetchOptions = new AuthorizationGroupFetchOptions();
        fetchOptions.withUsers().withSpace();
        fetchOptions.withRoleAssignments().withSpace();
        return service.searchAuthorizationGroups(sessionToken, searchCriteria, fetchOptions).getObjects();
    }

    private List<Person> getAllUsers(String sessionToken, IApplicationServerInternalApi service) {
        PersonSearchCriteria searchCriteria = new PersonSearchCriteria();
        PersonFetchOptions fetchOptions = new PersonFetchOptions();
        fetchOptions.withRoleAssignments().withSpace();
        fetchOptions.withSpace();
        return service.searchPersons(sessionToken, searchCriteria, fetchOptions).getObjects();
    }

    private List<Space> getAllSpaces(String sessionToken, IApplicationServerInternalApi service) {
        SpaceSearchCriteria searchCriteria = new SpaceSearchCriteria();
        SpaceFetchOptions fetchOptions = new SpaceFetchOptions();
        return service.searchSpaces(sessionToken, searchCriteria, fetchOptions).getObjects();
    }

    private void manageGroup(String sessionToken, String groupCode, Map<String, Principal> groupUsers, CurrentState currentState, UserManagerReport report) {
        try {
            Context context = new Context(sessionToken, this.service, currentState, report);
            if (currentState.groupExists(groupCode)) {
                this.manageKnownGroup(context, groupCode, groupUsers);
            } else {
                this.manageNewGroup(context, groupCode, groupUsers);
            }
            this.createSamples(context, groupCode);
            this.createExperiments(context, groupCode);
            context.executeOperations();
        }
        catch (Exception e) {
            String message = String.format("Couldn't manage group '%s' because of the following error: %s", groupCode, e);
            report.addErrorMessage(message);
            this.logger.log(LogLevel.ERROR, message, (Throwable)e);
        }
    }

    private void createSamples(Context context, String groupCode) {
        if (!this.commonSamples.isEmpty()) {
            LinkedHashSet<SampleIdentifier> sampleIdentifiers = new LinkedHashSet<SampleIdentifier>();
            String sessionToken = context.getSessionToken();
            for (Map.Entry<String, String> entry : this.commonSamples.entrySet()) {
                String sampleType = entry.getValue();
                String[] identifierTemplateParts = entry.getKey().split("/");
                String spaceCode = this.createCommonSpaceCode(groupCode, identifierTemplateParts[0]);
                String sampleCode = this.createCommonSpaceCode(groupCode, identifierTemplateParts[1]);
                SampleIdentifier sampleId = new SampleIdentifier(spaceCode, null, sampleCode);
                sampleIdentifiers.add(sampleId);
                if (!this.service.getSamples(sessionToken, Arrays.asList(sampleId), new SampleFetchOptions()).isEmpty()) continue;
                SampleCreation sampleCreation = new SampleCreation();
                sampleCreation.setCode(sampleCode);
                sampleCreation.setTypeId((IEntityTypeId)new EntityTypePermId(sampleType));
                sampleCreation.setSpaceId((ISpaceId)new SpacePermId(spaceCode));
                context.add(sampleCreation);
                context.getReport().addSample((ISampleId)sampleId);
            }
        }
    }

    private void createExperiments(Context context, String groupCode) {
        if (!this.commonExperiments.isEmpty()) {
            LinkedHashSet<ProjectIdentifier> projectIdentifiers = new LinkedHashSet<ProjectIdentifier>();
            Set<String> keySet = this.commonExperiments.keySet();
            for (String identifierTemplate : keySet) {
                String[] identifierTemplateParts = identifierTemplate.split("/");
                String string = this.createCommonSpaceCode(groupCode, identifierTemplateParts[0]);
                String projectCode = this.createCommonSpaceCode(groupCode, identifierTemplateParts[1]);
                projectIdentifiers.add(new ProjectIdentifier(string, projectCode));
            }
            String sessionToken = context.getSessionToken();
            Set existingProjects = this.service.getProjects(sessionToken, new ArrayList(projectIdentifiers), new ProjectFetchOptions()).keySet();
            projectIdentifiers.removeAll(existingProjects);
            for (ProjectIdentifier projectIdentifier : projectIdentifiers) {
                ProjectCreation projectCreation = new ProjectCreation();
                String[] spaceCodeAndProjectCode = projectIdentifier.getIdentifier().split("/");
                projectCreation.setSpaceId((ISpaceId)new SpacePermId(spaceCodeAndProjectCode[1]));
                projectCreation.setCode(spaceCodeAndProjectCode[2]);
                context.add(projectCreation);
                context.getReport().addProject(projectIdentifier);
            }
            for (Map.Entry entry : this.commonExperiments.entrySet()) {
                String experimentType = (String)entry.getValue();
                String[] identifierTemplateParts = ((String)entry.getKey()).split("/");
                String spaceCode = this.createCommonSpaceCode(groupCode, identifierTemplateParts[0]);
                String projectCode = this.createCommonSpaceCode(groupCode, identifierTemplateParts[1]);
                String experimentCode = this.createCommonSpaceCode(groupCode, identifierTemplateParts[2]);
                ExperimentIdentifier identifier = new ExperimentIdentifier(spaceCode, projectCode, experimentCode);
                if (!this.service.getExperiments(sessionToken, Arrays.asList(identifier), new ExperimentFetchOptions()).isEmpty()) continue;
                ExperimentCreation experimentCreation = new ExperimentCreation();
                experimentCreation.setProjectId((IProjectId)new ProjectIdentifier(spaceCode, projectCode));
                experimentCreation.setCode(experimentCode);
                experimentCreation.setTypeId((IEntityTypeId)new EntityTypePermId(experimentType));
                context.add(experimentCreation);
                context.getReport().addExperiment(identifier);
            }
        }
    }

    private void manageKnownGroup(Context context, String groupCode, Map<String, Principal> groupUsers) {
        this.createCommonSpaces(context, groupCode);
        this.manageUsers(context, groupCode, groupUsers);
    }

    private void manageNewGroup(Context context, String groupCode, Map<String, Principal> groupUsers) {
        String adminGroupCode = UserManager.createAdminGroupCode(groupCode);
        this.assertNoCommonSpaceExists(context, groupCode);
        this.createAuthorizationGroup(context, groupCode);
        this.createAuthorizationGroup(context, adminGroupCode);
        this.createCommonSpaces(context, groupCode);
        this.manageUsers(context, groupCode, groupUsers);
    }

    private void createCommonSpaces(Context context, String groupCode) {
        for (Map.Entry<Role, List<String>> entry : this.commonSpacesByRole.entrySet()) {
            Role role = entry.getKey();
            for (String commonSpaceCode : entry.getValue()) {
                String spaceCode = this.createCommonSpaceCode(groupCode, commonSpaceCode);
                Space space = context.getCurrentState().getSpace(spaceCode);
                if (space != null) continue;
                SpacePermId spaceId = this.createSpace(context, spaceCode);
                this.createRoleAssignment(context, new AuthorizationGroupPermId(groupCode), role, (ISpaceId)spaceId);
                this.createRoleAssignment(context, new AuthorizationGroupPermId(UserManager.createAdminGroupCode(groupCode)), Role.ADMIN, (ISpaceId)spaceId);
            }
        }
    }

    private void manageUsers(Context context, String groupCode, Map<String, Principal> groupUsers) {
        UserGroup group = this.groupsByCode.get(groupCode);
        Map<String, Person> currentUsersOfGroup = context.currentState.getCurrentUsersOfGroup(groupCode);
        TreeSet<String> usersToBeRemoved = new TreeSet<String>(currentUsersOfGroup.keySet());
        AuthorizationGroup globalGroup = context.currentState.getGlobalGroup();
        String adminGroupCode = UserManager.createAdminGroupCode(groupCode);
        boolean createUserSpace = group == null || group.isCreateUserSpace();
        boolean useEmailAsUserId = group != null && group.isUseEmailAsUserId();
        for (Principal user : groupUsers.values()) {
            String userId = this.getUserId(user, useEmailAsUserId);
            usersToBeRemoved.remove(userId);
            PersonPermId personId = new PersonPermId(userId);
            if (!currentUsersOfGroup.containsKey(userId)) {
                this.handleNewGroupUser(context, groupCode, createUserSpace, userId, personId);
            }
            this.addPersonToAuthorizationGroup(context, groupCode, userId);
            if (globalGroup != null) {
                this.addPersonToAuthorizationGroup(context, globalGroup.getCode(), userId);
            }
            if (this.isAdmin(userId, groupCode)) {
                this.addPersonToAuthorizationGroup(context, adminGroupCode, userId);
                continue;
            }
            this.removePersonFromAuthorizationGroup(context, adminGroupCode, userId);
        }
        this.removeUsersFromGroup(context, groupCode, usersToBeRemoved, useEmailAsUserId);
        this.handleRoleAssignmentForUserSpaces(context, groupCode);
    }

    private void handleRoleAssignmentForUserSpaces(Context context, String groupCode) {
        UserGroup group = this.groupsByCode.get(groupCode);
        Map<String, Person> currentUsersOfGroup = context.currentState.getCurrentUsersOfGroup(groupCode);
        Set<String> allUserSpaces = this.getAllUserSpaces(context, groupCode, currentUsersOfGroup);
        Role userSpaceRole = group.getUserSpaceRole();
        AuthorizationGroup authorizationGroup = (AuthorizationGroup)context.currentState.groupsByCode.get(groupCode);
        AuthorizationGroupPermId groupId = new AuthorizationGroupPermId(groupCode);
        for (String spaceCode : allUserSpaces) {
            List roleAssignments = authorizationGroup.getRoleAssignments().stream().filter(ra -> ra.getSpace() != null && ra.getSpace().getCode().equals(spaceCode)).collect(Collectors.toList());
            for (RoleAssignment roleAssignment : roleAssignments) {
                Role role = roleAssignment.getRole();
                SpacePermId permId = roleAssignment.getSpace().getPermId();
                if (userSpaceRole == role) continue;
                if (role != null) {
                    context.delete(roleAssignment.getId());
                    context.report.unassignRoleFrom((IAuthorizationGroupId)groupId, roleAssignment.getRole(), (ISpaceId)permId);
                }
                if (userSpaceRole == null) continue;
                this.createRoleAssignment(context, groupId, userSpaceRole, (ISpaceId)permId);
            }
            if (!roleAssignments.isEmpty() || userSpaceRole == null) continue;
            Space space = context.currentState.getSpace(spaceCode);
            this.createRoleAssignment(context, groupId, userSpaceRole, (ISpaceId)space.getPermId());
        }
    }

    private Set<String> getAllUserSpaces(Context context, String groupCode, Map<String, Person> currentUsersOfGroup) {
        String prefix = groupCode + "_";
        Set allGroupSpaces = context.getCurrentState().spacesByCode.keySet().stream().filter(space -> space.startsWith(prefix)).collect(Collectors.toSet());
        TreeSet<String> allUserSpaces = new TreeSet<String>();
        Set users = currentUsersOfGroup.keySet().stream().map(u -> u.toUpperCase()).collect(Collectors.toSet());
        for (String userId : users) {
            String space2 = prefix + userId;
            if (!allGroupSpaces.remove(space2)) continue;
            allUserSpaces.add(space2);
        }
        Pattern pattern = Pattern.compile(prefix + "(.*?)(_[0-9]+)?$");
        for (String space2 : allGroupSpaces) {
            Matcher matcher = pattern.matcher(space2);
            if (!matcher.matches() || !users.contains(matcher.group(1))) continue;
            allUserSpaces.add(space2);
        }
        return allUserSpaces;
    }

    private void handleNewGroupUser(Context context, String groupCode, boolean createUserSpace, String userId, PersonPermId personId) {
        SpacePermId userSpaceId = null;
        if (createUserSpace) {
            userSpaceId = this.createUserSpace(context, groupCode, userId);
        }
        Person knownUser = context.getCurrentState().getUser(userId);
        if (!context.getCurrentState().userExists(userId)) {
            PersonCreation personCreation = new PersonCreation();
            personCreation.setUserId(userId);
            context.add(personCreation);
            context.getCurrentState().addNewUser(userId);
            context.getReport().addUser(userId);
        } else if (knownUser != null && !knownUser.isActive().booleanValue()) {
            PersonUpdate personUpdate = new PersonUpdate();
            personUpdate.setUserId((IPersonId)personId);
            personUpdate.activate();
            context.add(personUpdate);
            context.getReport().reuseUser(userId);
        }
        if (createUserSpace) {
            Role userSpaceRole;
            this.getHomeSpaceRequest(userId).setHomeSpace(userSpaceId);
            RoleAssignmentCreation roleCreation = new RoleAssignmentCreation();
            roleCreation.setUserId((IPersonId)personId);
            roleCreation.setRole(Role.ADMIN);
            roleCreation.setSpaceId((ISpaceId)userSpaceId);
            context.add(roleCreation);
            AuthorizationGroupPermId adminGroupId = new AuthorizationGroupPermId(UserManager.createAdminGroupCode(groupCode));
            this.createRoleAssignment(context, adminGroupId, Role.ADMIN, (ISpaceId)userSpaceId);
            UserGroup group = this.groupsByCode.get(groupCode);
            Role role = userSpaceRole = group == null ? null : group.getUserSpaceRole();
            if (userSpaceRole != null) {
                this.createRoleAssignment(context, new AuthorizationGroupPermId(groupCode), userSpaceRole, (ISpaceId)userSpaceId);
            }
        }
    }

    private void removeUsersFromGroup(Context context, String groupCode, Set<String> usersToBeRemoved, boolean useEmailAsUserId) {
        String adminGroupCode = UserManager.createAdminGroupCode(groupCode);
        for (String userId : usersToBeRemoved) {
            this.removePersonFromAuthorizationGroup(context, groupCode, userId);
            this.removePersonFromAuthorizationGroup(context, adminGroupCode, userId);
            AuthorizationGroup globalGroup = context.currentState.getGlobalGroup();
            if (globalGroup != null) {
                this.removePersonFromAuthorizationGroup(context, globalGroup.getCode(), userId);
            }
            Person user = context.currentState.getUser(userId);
            for (RoleAssignment roleAssignment : user.getRoleAssignments()) {
                Space space = roleAssignment.getSpace();
                String userSpace = this.createCommonSpaceCode(groupCode, userId.toUpperCase());
                if (space == null || !space.getCode().startsWith(userSpace)) continue;
                context.delete(roleAssignment.getId());
                context.report.unassignRoleFrom(userId, roleAssignment.getRole(), (ISpaceId)space.getPermId());
            }
        }
    }

    private String getUserId(Principal user, boolean useEmailAsUserId) {
        if (useEmailAsUserId && StringUtils.isNotBlank((CharSequence)user.getEmail())) {
            return ServerUtils.escapeEmail(user.getEmail());
        }
        return user.getUserId();
    }

    private SpacePermId createUserSpace(Context context, String groupCode, String userId) {
        String userSpaceCode = this.createCommonSpaceCode(groupCode, userId.toUpperCase());
        int n = context.getCurrentState().getNumberOfSpacesStartingWith(userSpaceCode);
        if (n > 0) {
            userSpaceCode = userSpaceCode + "_" + (n + 1);
        }
        return this.createSpace(context, userSpaceCode);
    }

    private HomeSpaceRequest getHomeSpaceRequest(String userId) {
        HomeSpaceRequest homeSpaceRequest = this.requestedHomeSpaceByUserId.get(userId);
        if (homeSpaceRequest == null) {
            homeSpaceRequest = new HomeSpaceRequest();
            this.requestedHomeSpaceByUserId.put(userId, homeSpaceRequest);
        }
        return homeSpaceRequest;
    }

    private boolean isAdmin(String userId, String groupCode) {
        UserInfo userInfo = this.userInfosByUserId.get(userId);
        if (userInfo == null) {
            return false;
        }
        GroupInfo groupInfo = userInfo.getGroupInfosByGroupKey().get(groupCode);
        return groupInfo != null && groupInfo.isAdmin();
    }

    private void addPersonToAuthorizationGroup(Context context, String groupCode, String userId) {
        if (!context.currentState.getCurrentUsersOfGroup(groupCode).keySet().contains(userId)) {
            AuthorizationGroupUpdate groupUpdate = new AuthorizationGroupUpdate();
            groupUpdate.setAuthorizationGroupId((IAuthorizationGroupId)new AuthorizationGroupPermId(groupCode));
            groupUpdate.getUserIds().add((Object[])new IPersonId[]{new PersonPermId(userId)});
            context.add(groupUpdate);
            context.getReport().addUserToGroup(groupCode, userId);
        }
    }

    private void removePersonFromAuthorizationGroup(Context context, String groupCode, String userId) {
        if (context.currentState.getCurrentUsersOfGroup(groupCode).keySet().contains(userId)) {
            AuthorizationGroupUpdate groupUpdate = new AuthorizationGroupUpdate();
            groupUpdate.setAuthorizationGroupId((IAuthorizationGroupId)new AuthorizationGroupPermId(groupCode));
            groupUpdate.getUserIds().remove((Object[])new IPersonId[]{new PersonPermId(userId)});
            context.add(groupUpdate);
            context.getReport().removeUserFromGroup(groupCode, userId);
        }
    }

    private AuthorizationGroupPermId createAuthorizationGroup(Context context, String groupCode) {
        AuthorizationGroupCreation creation = new AuthorizationGroupCreation();
        creation.setCode(groupCode);
        context.add(creation);
        context.getReport().addGroup(groupCode);
        return new AuthorizationGroupPermId(groupCode);
    }

    private void createRoleAssignment(Context context, AuthorizationGroupPermId groupId, Role role, ISpaceId spaceId) {
        RoleAssignmentCreation roleCreation = new RoleAssignmentCreation();
        roleCreation.setAuthorizationGroupId((IAuthorizationGroupId)groupId);
        roleCreation.setRole(role);
        roleCreation.setSpaceId(spaceId);
        context.add(roleCreation);
        context.getReport().assignRoleTo(groupId, role, spaceId);
    }

    private void assertNoCommonSpaceExists(Context context, String groupCode) {
        TreeSet<String> commonSpaces = new TreeSet<String>();
        for (List<String> set : this.commonSpacesByRole.values()) {
            commonSpaces.addAll(set.stream().map(s -> this.createCommonSpaceCode(groupCode, (String)s)).collect(Collectors.toList()));
        }
        Map<ISpaceId, Space> spaces = this.getSpaces(context.getSessionToken(), commonSpaces);
        if (spaces.isEmpty()) {
            return;
        }
        List existingSpaces = new ArrayList<Space>(spaces.values()).stream().map(Space::getCode).collect(Collectors.toList());
        Collections.sort(existingSpaces);
        throw new IllegalStateException("The group '" + groupCode + "' has already the following spaces: " + existingSpaces);
    }

    private SpacePermId createSpace(Context context, String spaceCode) {
        SpaceCreation spaceCreation = new SpaceCreation();
        spaceCreation.setCode(spaceCode);
        context.add(spaceCreation);
        SpacePermId spaceId = new SpacePermId(spaceCode);
        context.getReport().addSpace((ISpaceId)spaceId);
        return spaceId;
    }

    private String createCommonSpaceCode(String groupCode, String spaceCode) {
        return groupCode + "_" + spaceCode;
    }

    public static String createAdminGroupCode(String groupCode) {
        return groupCode + "_ADMIN";
    }

    private Map<ISpaceId, Space> getSpaces(String sessionToken, Collection<String> spaceCodes) {
        SpaceFetchOptions fetchOptions = new SpaceFetchOptions();
        return this.service.getSpaces(sessionToken, spaceCodes.stream().map(SpacePermId::new).collect(Collectors.toList()), fetchOptions);
    }

    private Set<String> asSet(List<String> users) {
        return users == null ? Collections.emptySet() : new TreeSet<String>(users);
    }

    private static final class Context {
        private String sessionToken;
        private Map<String, PersonCreation> personCreations = new LinkedMap();
        private Map<IPersonId, PersonUpdate> personUpdates = new LinkedMap();
        private List<SpaceCreation> spaceCreations = new ArrayList<SpaceCreation>();
        private List<ProjectCreation> projectCreations = new ArrayList<ProjectCreation>();
        private List<SampleCreation> sampleCreations = new ArrayList<SampleCreation>();
        private List<ExperimentCreation> experimentCreations = new ArrayList<ExperimentCreation>();
        private List<AuthorizationGroupCreation> groupCreations = new ArrayList<AuthorizationGroupCreation>();
        private List<AuthorizationGroupUpdate> groupUpdates = new ArrayList<AuthorizationGroupUpdate>();
        private List<RoleAssignmentCreation> roleCreations = new ArrayList<RoleAssignmentCreation>();
        private List<IRoleAssignmentId> roleDeletions = new ArrayList<IRoleAssignmentId>();
        private IApplicationServerInternalApi service;
        private CurrentState currentState;
        private UserManagerReport report;

        Context(String sessionToken, IApplicationServerInternalApi service, CurrentState currentState, UserManagerReport report) {
            this.sessionToken = sessionToken;
            this.service = service;
            this.currentState = currentState;
            this.report = report;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public CurrentState getCurrentState() {
            return this.currentState;
        }

        public UserManagerReport getReport() {
            return this.report;
        }

        public void add(PersonCreation personCreation) {
            this.personCreations.put(personCreation.getUserId(), personCreation);
        }

        public void add(PersonUpdate personUpdate) {
            this.personUpdates.put(personUpdate.getUserId(), personUpdate);
        }

        public void add(SpaceCreation spaceCreation) {
            this.spaceCreations.add(spaceCreation);
        }

        public void add(ProjectCreation projectCreation) {
            this.projectCreations.add(projectCreation);
        }

        public void add(SampleCreation sampleCreation) {
            this.sampleCreations.add(sampleCreation);
        }

        public void add(ExperimentCreation experimentCreation) {
            this.experimentCreations.add(experimentCreation);
        }

        public void add(AuthorizationGroupCreation creation) {
            this.groupCreations.add(creation);
        }

        public void add(RoleAssignmentCreation roleCreation) {
            this.roleCreations.add(roleCreation);
        }

        public void add(AuthorizationGroupUpdate groupUpdate) {
            this.groupUpdates.add(groupUpdate);
        }

        public void delete(IRoleAssignmentId roleAssignmentId) {
            this.roleDeletions.add(roleAssignmentId);
        }

        public void executeOperations() {
            RoleAssignmentDeletionOptions options;
            ArrayList<Object> operations = new ArrayList<Object>();
            if (!this.personCreations.isEmpty()) {
                operations.add(new CreatePersonsOperation(new ArrayList<PersonCreation>(this.personCreations.values())));
            }
            if (!this.personUpdates.isEmpty()) {
                operations.add(new UpdatePersonsOperation(new ArrayList<PersonUpdate>(this.personUpdates.values())));
            }
            if (!this.spaceCreations.isEmpty()) {
                operations.add(new CreateSpacesOperation(this.spaceCreations));
            }
            if (!this.projectCreations.isEmpty()) {
                operations.add(new CreateProjectsOperation(this.projectCreations));
            }
            if (!this.sampleCreations.isEmpty()) {
                operations.add(new CreateSamplesOperation(this.sampleCreations));
            }
            if (!this.experimentCreations.isEmpty()) {
                operations.add(new CreateExperimentsOperation(this.experimentCreations));
            }
            if (!this.groupCreations.isEmpty()) {
                operations.add(new CreateAuthorizationGroupsOperation(this.groupCreations));
            }
            if (!this.groupUpdates.isEmpty()) {
                operations.add(new UpdateAuthorizationGroupsOperation(this.groupUpdates));
            }
            if (!this.roleCreations.isEmpty()) {
                operations.add(new CreateRoleAssignmentsOperation(this.roleCreations));
            }
            if (!this.roleDeletions.isEmpty()) {
                options = new RoleAssignmentDeletionOptions();
                options.setReason("Users removed from a group");
                operations.add(new DeleteRoleAssignmentsOperation(this.roleDeletions, options));
            }
            if (operations.isEmpty()) {
                return;
            }
            options = new SynchronousOperationExecutionOptions();
            this.service.executeOperations(this.sessionToken, operations, (IOperationExecutionOptions)options);
        }
    }

    private static final class HomeSpaceRequest {
        private SpacePermId homeSpace;

        private HomeSpaceRequest() {
        }

        public SpacePermId getHomeSpace() {
            return this.homeSpace;
        }

        public void setHomeSpace(SpacePermId homeSpace) {
            if (this.homeSpace == null) {
                this.homeSpace = homeSpace;
            }
        }
    }

    private static final class MappingAttributes {
        private String groupCode;
        private List<String> shareIds;

        public MappingAttributes(String groupCode, List<String> shareIds) {
            this.groupCode = groupCode;
            this.shareIds = shareIds;
        }

        public String getGroupCode() {
            return this.groupCode;
        }

        public List<String> getShareIds() {
            return this.shareIds;
        }
    }

    private static class GroupInfo {
        private String key;
        private boolean admin;

        GroupInfo(String key, boolean admin) {
            this.key = key;
            this.admin = admin;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public String toString() {
            return this.key + (this.admin ? "*" : "");
        }
    }

    private static class UserInfo {
        private Principal principal;
        private Map<String, GroupInfo> groupInfosByGroupKey = new TreeMap<String, GroupInfo>();

        public UserInfo(Principal principal) {
            this.principal = principal;
        }

        public void addGroupInfo(GroupInfo groupInfo) {
            this.groupInfosByGroupKey.put(groupInfo.getKey(), groupInfo);
        }

        public Map<String, GroupInfo> getGroupInfosByGroupKey() {
            return this.groupInfosByGroupKey;
        }

        public String toString() {
            return this.principal.getUserId() + " " + this.groupInfosByGroupKey.values();
        }
    }

    private static final class CurrentState {
        private Map<String, AuthorizationGroup> groupsByCode = new TreeMap<String, AuthorizationGroup>();
        private Map<String, Space> spacesByCode = new TreeMap<String, Space>();
        private Map<String, Person> usersById = new TreeMap<String, Person>();
        private Set<String> newUsers = new TreeSet<String>();
        private AuthorizationGroup globalGroup;

        CurrentState(List<AuthorizationGroup> authorizationGroups, AuthorizationGroup globalGroup, List<Space> spaces, List<Person> users) {
            this.globalGroup = globalGroup;
            authorizationGroups.forEach(group -> this.groupsByCode.put(group.getCode(), (AuthorizationGroup)group));
            this.groupsByCode.put(UserManager.GLOBAL_AUTHORIZATION_GROUP_CODE, globalGroup);
            spaces.forEach(space -> this.spacesByCode.put(space.getCode(), (Space)space));
            users.forEach(user -> this.usersById.put(user.getUserId(), (Person)user));
        }

        public Map<String, Person> getCurrentUsersOfGroup(String groupCode) {
            TreeMap<String, Person> result = new TreeMap<String, Person>();
            AuthorizationGroup group = this.groupsByCode.get(groupCode);
            if (group != null) {
                group.getUsers().forEach(user -> result.put(user.getUserId(), (Person)user));
            }
            return result;
        }

        public AuthorizationGroup getGlobalGroup() {
            return this.globalGroup;
        }

        public boolean userExists(String userId) {
            return this.newUsers.contains(userId) || this.usersById.containsKey(userId);
        }

        public Space getSpace(String spaceCode) {
            return this.spacesByCode.get(spaceCode);
        }

        public int getNumberOfSpacesStartingWith(String userSpaceCode) {
            Predicate<String> predicate = code -> code.startsWith(userSpaceCode);
            return this.spacesByCode.keySet().stream().filter(predicate).collect(Collectors.counting()).intValue();
        }

        public Person getUser(String userId) {
            return this.usersById.get(userId);
        }

        public boolean groupExists(String groupCode) {
            boolean groupExists = this.groupsByCode.containsKey(groupCode);
            String adminGroupCode = UserManager.createAdminGroupCode(groupCode);
            boolean adminGroupExists = this.groupsByCode.containsKey(adminGroupCode);
            if (groupExists) {
                if (!adminGroupExists) {
                    throw new IllegalArgumentException("Group " + groupCode + " exists but not " + adminGroupCode);
                }
                return true;
            }
            if (adminGroupExists) {
                throw new IllegalArgumentException("Group " + groupCode + " does not exist but " + adminGroupCode);
            }
            return false;
        }

        public void addNewUser(String userId) {
            this.newUsers.add(userId);
        }
    }
}

