/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.AuthorizationGroupPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.id.IAuthorizationGroupId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.Role;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.create.SpaceCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.systemsx.cisd.common.logging.BufferedAppender;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.openbis.generic.server.task.IChangedHandler;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class UserManagerReport
implements IChangedHandler {
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private StringBuilder errorReport = new StringBuilder();
    private StringBuilder auditLog = new StringBuilder();
    private ITimeProvider timeProvider;
    private BufferedAppender bufferedAppender;

    public UserManagerReport(ITimeProvider timeProvider) {
        this(timeProvider, null);
    }

    public UserManagerReport(ITimeProvider timeProvider, BufferedAppender bufferedAppender) {
        this.timeProvider = timeProvider;
        this.bufferedAppender = bufferedAppender;
    }

    public String getLog() {
        return this.bufferedAppender != null ? this.bufferedAppender.getLogContent() : "";
    }

    public String getErrorReport() {
        return this.errorReport.toString();
    }

    public String getAuditLog() {
        return this.auditLog.toString();
    }

    void addErrorMessage(String message) {
        this.errorReport.append(message).append('\n');
    }

    void addGroup(String groupCode) {
        this.log("ADD-AUTHORIZATION-GROUP", groupCode);
    }

    void deactivateUser(String userId) {
        this.log("DEACTIVATE-USER", userId);
    }

    void addUser(String userId) {
        this.log("ADD-USER", userId);
    }

    void reuseUser(String userId) {
        this.log("REUSE-USER", userId);
    }

    void addSpace(ISpaceId spaceId) {
        this.log("ADD-SPACE", spaceId);
    }

    void addSpaces(List<SpaceCreation> spaceCreations) {
        this.log("ADD-SPACES", spaceCreations.stream().map(SpaceCreation::getCode).collect(Collectors.toList()).toString());
    }

    void addSample(ISampleId sampleId) {
        this.log("ADD-SAMPLE", sampleId);
    }

    void addProject(ProjectIdentifier identifier) {
        this.log("ADD-PROJECT", identifier);
    }

    void addExperiment(ExperimentIdentifier identifier) {
        this.log("ADD-EXPERIMENT", identifier);
    }

    void assignRoleTo(AuthorizationGroupPermId groupId, Role role, ISpaceId spaceId) {
        this.log("ASSIGN-ROLE-TO-AUTHORIZATION-GROUP", "group: " + groupId + ", role: SPACE_" + role + " for " + spaceId);
    }

    void unassignRoleFrom(String userId, Role role, ISpaceId spaceId) {
        this.log("UNASSIGN-ROLE-FORM-USER", "user: " + userId + ", role: SPACE_" + role + " for " + spaceId);
    }

    void unassignRoleFrom(IAuthorizationGroupId groupId, Role role, ISpaceId spaceId) {
        this.log("UNASSIGN-ROLE-FORM-AUTHORIZATION-GROUP", "group: " + groupId + ", role: SPACE_" + role + " for " + spaceId);
    }

    void addUserToGroup(String groupCode, String userId) {
        this.log("ADD-USER-TO-AUTHORIZATION-GROUP", "group: " + groupCode + ", user: " + userId);
    }

    void removeUserFromGroup(String groupCode, String userId) {
        this.log("REMOVE-USER-FROM-AUTHORIZATION-GROUP", "group: " + groupCode + ", user: " + userId);
    }

    void assignHomeSpace(String userId, ISpaceId spaceIdOrNull) {
        this.log("ASSIGN-HOME-SPACE-FOR-USER", "user: " + userId + ", home space: " + spaceIdOrNull);
    }

    @Override
    public void changed(String str, Date date) {
        this.log("CONFIG-UPDATE-START", "Last modified: " + new SimpleDateFormat(DATE_FORMAT).format(date));
        this.auditLog.append(str);
        this.log("CONFIG-UPDATE-END", "");
    }

    private void log(String action, Object details) {
        Date timeStamp = new Date(this.timeProvider.getTimeInMilliseconds());
        MessageFormat messageFormat = new MessageFormat("{0,date,yyyy-MM-dd HH:mm:ss} [{1}] {2}\n");
        this.auditLog.append(messageFormat.format(new Object[]{timeStamp, action, details}));
    }
}

