/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.DeletionEventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AttachmentDeletionProcessor
extends DeletionEventProcessor {
    AttachmentDeletionProcessor(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected EventPE.EntityType getEntityType() {
        return EventPE.EntityType.ATTACHMENT;
    }

    @Override
    protected Set<EventPE.EntityType> getAscendantEntityTypes() {
        return Collections.emptySet();
    }

    @Override
    protected Set<EventPE.EntityType> getDescendantEntityTypes() {
        return Collections.emptySet();
    }

    @Override
    protected void processDeletion(LastTimestamps lastTimestamps, EventPE deletion, List<NewEvent> newEvents, List<Snapshot> newSnapshots) throws Exception {
        if (deletion.getContent() == null || deletion.getContent().trim().isEmpty()) {
            for (String attachmentPath : deletion.getIdentifiers()) {
                NewEvent newEvent = NewEvent.fromOldEventPE(deletion);
                newEvent.identifier = attachmentPath;
                newEvents.add(newEvent);
            }
            return;
        }
        Map parsedContent = (Map)OBJECT_MAPPER.readValue(deletion.getContent(), Object.class);
        for (String attachmentPath : parsedContent.keySet()) {
            List entries = (List)parsedContent.get(attachmentPath);
            for (Map entry : entries) {
                String type = (String)entry.get("type");
                String key = (String)entry.get("key");
                if (!"ATTACHMENT".equals(type) || !"OWNED".equals(key)) continue;
                String entityType = (String)entry.get("entityType");
                String value = (String)entry.get("value");
                Snapshot snapshot = new Snapshot();
                if (EventPE.EntityType.PROJECT.name().equals(entityType)) {
                    snapshot.projectPermId = value;
                } else if (EventPE.EntityType.EXPERIMENT.name().equals(entityType)) {
                    snapshot.experimentPermId = value;
                } else if (EventPE.EntityType.SAMPLE.name().equals(entityType)) {
                    snapshot.samplePermId = value;
                }
                newSnapshots.add(snapshot);
                NewEvent newEvent = NewEvent.fromOldEventPE(deletion);
                newEvent.identifier = attachmentPath;
                newEvent.entityProjectPermId = snapshot.projectPermId;
                newEvent.entityExperimentPermId = snapshot.experimentPermId;
                newEvent.entitySamplePermId = snapshot.samplePermId;
                newEvent.entityRegisterer = (String)entry.get("userId");
                newEvent.content = OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)entries);
                String validFrom = (String)entry.get("validFrom");
                if (validFrom != null) {
                    newEvent.entityRegistrationTimestamp = ENTRY_VALID_TIMESTAMP_FORMAT.parse(validFrom);
                }
                newEvents.add(newEvent);
            }
        }
    }

    @Override
    protected void processDeletions(LastTimestamps lastTimestamps, SnapshotsFacade snapshots, List<NewEvent> newEvents, List<Snapshot> newSnapshots) {
        snapshots.loadExistingProjects(SnapshotsFacade.getProjectPermIdsOrUnknown(newSnapshots));
        snapshots.loadExistingExperiments(SnapshotsFacade.getExperimentPermIdsOrUnknown(newSnapshots));
        snapshots.loadExistingSamples(SnapshotsFacade.getSamplePermIdsOrUnknown(newSnapshots));
        for (NewEvent newEvent : newEvents) {
            try {
                if (newEvent.entityProjectPermId != null) {
                    snapshots.fillByProjectPermId(newEvent.entityProjectPermId, newEvent);
                } else if (newEvent.entityExperimentPermId != null) {
                    snapshots.fillByExperimentPermId(newEvent.entityExperimentPermId, newEvent);
                } else if (newEvent.entitySamplePermId != null) {
                    snapshots.fillBySamplePermId(newEvent.entitySamplePermId, newEvent);
                }
                this.dataSource.createEventsSearch(newEvent.toNewEventPE());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Processing of deletion failed: %s", newEvent), e);
            }
        }
    }
}

