/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.DeletionEventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class DataSetDeletionProcessor
extends DeletionEventProcessor {
    DataSetDeletionProcessor(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected EventPE.EntityType getEntityType() {
        return EventPE.EntityType.DATASET;
    }

    @Override
    protected Set<EventPE.EntityType> getAscendantEntityTypes() {
        return EnumSet.of(EventPE.EntityType.EXPERIMENT, EventPE.EntityType.SAMPLE);
    }

    @Override
    protected Set<EventPE.EntityType> getDescendantEntityTypes() {
        return Collections.emptySet();
    }

    @Override
    protected int getBatchSize() {
        return 1;
    }

    @Override
    protected void processDeletion(LastTimestamps lastTimestamps, EventPE deletion, List<NewEvent> newEvents, List<Snapshot> newSnapshots) throws Exception {
        LinkedList<NewEvent> events = new LinkedList<NewEvent>();
        super.processDeletion(lastTimestamps, deletion, events, newSnapshots);
        List<DeletedDataSetLocation> locations = DeletedDataSetLocation.parse(deletion.getDescription());
        if (locations.size() == events.size()) {
            Iterator<DeletedDataSetLocation> locationIterator = locations.iterator();
            Iterator eventIterator = events.iterator();
            while (locationIterator.hasNext()) {
                NewEvent event = (NewEvent)eventIterator.next();
                DeletedDataSetLocation location = locationIterator.next();
                event.description = DeletedDataSetLocation.format(Collections.singletonList(location));
            }
        }
        newEvents.addAll(events);
    }

    @Override
    protected void processDeletions(LastTimestamps lastTimestamps, SnapshotsFacade snapshots, List<NewEvent> newEvents, List<Snapshot> newSnapshots) {
        snapshots.putDataSets(newSnapshots);
        for (NewEvent newEvent : newEvents) {
            try {
                snapshots.fillByDataSetPermId(newEvent.identifier, newEvent);
                this.dataSource.createEventsSearch(newEvent.toNewEventPE());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Processing of deletion failed: %s", newEvent), e);
            }
        }
    }
}

