/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.IApplicationServerInternalApi;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEventsSearchDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Statistics;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventsSearchPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DataSource
implements IDataSource {
    private static final int LOG_LIMIT = 10;
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
    private final Stack<Statistics> statisticsStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics executeInNewTransaction(TransactionCallback<?> callback) {
        Statistics statistics = null;
        try {
            statistics = this.statisticsStack.push(new Statistics());
            PlatformTransactionManager manager = (PlatformTransactionManager)CommonServiceProvider.getApplicationContext().getBean(PlatformTransactionManager.class);
            DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
            definition.setPropagationBehavior(3);
            definition.setReadOnly(false);
            TransactionTemplate template = new TransactionTemplate(manager, (TransactionDefinition)definition);
            template.execute(callback);
            Statistics statistics2 = statistics;
            return statistics2;
        }
        finally {
            if (statistics != null) {
                this.statisticsStack.pop();
            }
        }
    }

    @Override
    public List<SpacePE> loadSpaces(List<String> codes) {
        ISpaceDAO spaceDAO = CommonServiceProvider.getDAOFactory().getSpaceDAO();
        List<SpacePE> result = spaceDAO.tryFindSpaceByCodes(codes);
        for (Statistics statistics : this.statisticsStack) {
            statistics.increaseLoadedSpaces(result.size());
        }
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Found " + result.size() + " space(s) for code(s): " + CollectionUtils.abbreviate(codes, (int)10)));
        }
        return result;
    }

    @Override
    public List<Project> loadProjects(List<IProjectId> ids, ProjectFetchOptions fo) {
        IApplicationServerInternalApi v3 = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = v3.loginAsSystem();
        Map result = v3.getProjects(sessionToken, ids, fo);
        for (Statistics statistics : this.statisticsStack) {
            statistics.increaseLoadedProjects(result.size());
        }
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Found " + result.size() + " project(s) for id(s): " + CollectionUtils.abbreviate(ids, (int)10)));
        }
        return new ArrayList<Project>(result.values());
    }

    @Override
    public List<Experiment> loadExperiments(List<IExperimentId> ids, ExperimentFetchOptions fo) {
        IApplicationServerInternalApi v3 = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = v3.loginAsSystem();
        Map result = v3.getExperiments(sessionToken, ids, fo);
        for (Statistics statistics : this.statisticsStack) {
            statistics.increaseLoadedExperiments(result.size());
        }
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Found " + result.size() + " experiment(s) for id(s): " + CollectionUtils.abbreviate(ids, (int)10)));
        }
        return new ArrayList<Experiment>(result.values());
    }

    @Override
    public List<Sample> loadSamples(List<ISampleId> ids, SampleFetchOptions fo) {
        IApplicationServerInternalApi v3 = CommonServiceProvider.getApplicationServerApi();
        String sessionToken = v3.loginAsSystem();
        Map result = v3.getSamples(sessionToken, ids, fo);
        for (Statistics statistics : this.statisticsStack) {
            statistics.increaseLoadedSamples(result.size());
        }
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Found " + result.size() + " sample(s) for id(s): " + CollectionUtils.abbreviate(ids, (int)10)));
        }
        return new ArrayList<Sample>(result.values());
    }

    @Override
    public List<EventPE> loadEvents(EventType eventType, EventPE.EntityType entityType, Date lastSeenTimestampOrNull, Integer limitOrNull) {
        IEventDAO eventDAO = CommonServiceProvider.getDAOFactory().getEventDAO();
        List<EventPE> result = eventDAO.listEvents(eventType, entityType, lastSeenTimestampOrNull, limitOrNull);
        for (Statistics statistics : this.statisticsStack) {
            statistics.increaseLoadedEvents(result.size());
        }
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Found " + result.size() + " event(s) for eventType: " + (Object)((Object)eventType) + ", entityType: " + (Object)((Object)entityType) + ", lastSeenTimestamp: " + lastSeenTimestampOrNull));
        }
        return result;
    }

    @Override
    public Date loadLastEventsSearchTimestamp(EventType eventType, EventPE.EntityType entityType) {
        IEventsSearchDAO eventsSearchDAO = CommonServiceProvider.getDAOFactory().getEventsSearchDAO();
        Date result = eventsSearchDAO.getLastTimestamp(eventType, entityType);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)("Found " + result + " last seen timestamp for eventType: " + (Object)((Object)eventType) + ", entityType: " + (Object)((Object)entityType)));
        }
        return result;
    }

    @Override
    public void createEventsSearch(EventsSearchPE eventsSearch) {
        IEventsSearchDAO eventsSearchDAO = CommonServiceProvider.getDAOFactory().getEventsSearchDAO();
        eventsSearchDAO.createOrUpdate(eventsSearch);
        for (Statistics statistics : this.statisticsStack) {
            statistics.increaseCreatedEvents(1);
        }
    }
}

