/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.EventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;

abstract class DeletionEventProcessor
extends EventProcessor {
    protected static final SimpleDateFormat ENTRY_REGISTRATION_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    protected static final SimpleDateFormat ENTRY_VALID_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final String ENTRY_TYPE = "type";
    protected static final String ENTRY_TYPE_ATTRIBUTE = "ATTRIBUTE";
    protected static final String ENTRY_TYPE_RELATIONSHIP = "RELATIONSHIP";
    protected static final String ENTRY_TYPE_ATTACHMENT = "ATTACHMENT";
    protected static final String ENTRY_KEY = "key";
    protected static final String ENTRY_KEY_CODE = "CODE";
    protected static final String ENTRY_KEY_REGISTRATOR = "REGISTRATOR";
    protected static final String ENTRY_KEY_REGISTRATION_TIMESTAMP = "REGISTRATION_TIMESTAMP";
    protected static final String ENTRY_KEY_OWNED = "OWNED";
    protected static final String ENTRY_VALUE = "value";
    protected static final String ENTRY_ENTITY_TYPE = "entityType";
    protected static final String ENTRY_ENTITY_TYPE_UNKNOWN = "UNKNOWN";
    protected static final String ENTRY_VALID_FROM = "validFrom";
    protected static final String ENTRY_VALID_UNTIL = "validUntil";
    protected static final String ENTRY_USER_ID = "userId";

    DeletionEventProcessor(IDataSource dataSource) {
        super(dataSource);
    }

    protected abstract EventPE.EntityType getEntityType();

    protected abstract Set<EventPE.EntityType> getAscendantEntityTypes();

    protected abstract Set<EventPE.EntityType> getDescendantEntityTypes();

    protected int getBatchSize() {
        return 1000;
    }

    protected abstract void processDeletions(LastTimestamps var1, SnapshotsFacade var2, List<NewEvent> var3, List<Snapshot> var4);

    @Override
    public final void process(LastTimestamps lastTimestamps, SnapshotsFacade snapshots) {
        List<EventPE> deletions;
        HashSet<EventPE.EntityType> lastSeenEntityTypes = new HashSet<EventPE.EntityType>();
        lastSeenEntityTypes.add(this.getEntityType());
        lastSeenEntityTypes.addAll(this.getDescendantEntityTypes());
        Date lastSeenTimestampOrNull = lastTimestamps.getEarliestOrNull(EventType.DELETION, lastSeenEntityTypes.toArray(new EventPE.EntityType[0]));
        MutableObject latestLastSeenTimestamp = new MutableObject((Object)lastSeenTimestampOrNull);
        while (!(deletions = this.dataSource.loadEvents(EventType.DELETION, this.getEntityType(), (Date)latestLastSeenTimestamp.getValue(), this.getBatchSize())).isEmpty()) {
            this.dataSource.executeInNewTransaction(status -> {
                LinkedList<NewEvent> newEvents = new LinkedList<NewEvent>();
                LinkedList<Snapshot> newSnapshots = new LinkedList<Snapshot>();
                for (EventPE deletion : deletions) {
                    try {
                        this.processDeletion(lastTimestamps, deletion, newEvents, newSnapshots);
                        if (latestLastSeenTimestamp.getValue() != null && !deletion.getRegistrationDateInternal().after((Date)latestLastSeenTimestamp.getValue())) continue;
                        latestLastSeenTimestamp.setValue((Object)deletion.getRegistrationDateInternal());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Processing of deletion failed: %s", deletion), e);
                    }
                }
                this.processDeletions(lastTimestamps, snapshots, newEvents, newSnapshots);
                return null;
            });
        }
    }

    protected void processDeletion(LastTimestamps lastTimestamps, EventPE deletion, List<NewEvent> newEvents, List<Snapshot> newSnapshots) throws Exception {
        Date lastSeenTimestampOrNull = lastTimestamps.getEarliestOrNull(EventType.DELETION, this.getEntityType());
        if (deletion.getContent() == null || deletion.getContent().trim().isEmpty()) {
            for (String entityPermId : deletion.getIdentifiers()) {
                Snapshot snapshot = new Snapshot();
                snapshot.entityPermId = entityPermId;
                snapshot.from = new Date(0L);
                snapshot.to = deletion.getRegistrationDateInternal();
                newSnapshots.add(snapshot);
                if (lastSeenTimestampOrNull != null && !deletion.getRegistrationDateInternal().after(lastSeenTimestampOrNull)) continue;
                NewEvent newEvent = NewEvent.fromOldEventPE(deletion);
                newEvent.identifier = entityPermId;
                newEvents.add(newEvent);
            }
            return;
        }
        Map parsedContent = (Map)OBJECT_MAPPER.readValue(deletion.getContent(), Object.class);
        for (String entityPermId : parsedContent.keySet()) {
            List entries = (List)parsedContent.get(entityPermId);
            String entityCode = null;
            String registerer = null;
            Date registrationTimestamp = null;
            for (Map entry : entries) {
                String type = (String)entry.get(ENTRY_TYPE);
                String key = (String)entry.get(ENTRY_KEY);
                String value = (String)entry.get(ENTRY_VALUE);
                if (!ENTRY_TYPE_ATTRIBUTE.equals(type)) continue;
                if (ENTRY_KEY_CODE.equals(key)) {
                    entityCode = value;
                    continue;
                }
                if (ENTRY_KEY_REGISTRATOR.equals(key)) {
                    registerer = value;
                    continue;
                }
                if (!ENTRY_KEY_REGISTRATION_TIMESTAMP.equals(key)) continue;
                registrationTimestamp = ENTRY_REGISTRATION_TIMESTAMP_FORMAT.parse(value);
            }
            Set relationshipEntityTypes = this.getAscendantEntityTypes().stream().map(Enum::name).collect(Collectors.toSet());
            Snapshot lastSnapshot = null;
            for (Map entry : entries) {
                String validUntil;
                String entityType;
                String type = (String)entry.get(ENTRY_TYPE);
                String key = (String)entry.get(ENTRY_KEY);
                if (!ENTRY_TYPE_RELATIONSHIP.equals(type) || !ENTRY_KEY_OWNED.equals(key) || !relationshipEntityTypes.contains(entityType = (String)entry.get(ENTRY_ENTITY_TYPE)) && !ENTRY_ENTITY_TYPE_UNKNOWN.equals(entityType)) continue;
                Snapshot snapshot = new Snapshot();
                snapshot.entityCode = entityCode;
                snapshot.entityPermId = entityPermId;
                String value = (String)entry.get(ENTRY_VALUE);
                if (EventPE.EntityType.SPACE.name().equals(entityType)) {
                    snapshot.spaceCode = value;
                } else if (EventPE.EntityType.PROJECT.name().equals(entityType)) {
                    snapshot.projectPermId = value;
                } else if (EventPE.EntityType.EXPERIMENT.name().equals(entityType)) {
                    snapshot.experimentPermId = value;
                } else if (EventPE.EntityType.SAMPLE.name().equals(entityType)) {
                    snapshot.samplePermId = value;
                } else {
                    snapshot.unknownPermId = value;
                }
                String validFrom = (String)entry.get(ENTRY_VALID_FROM);
                if (validFrom != null) {
                    snapshot.from = ENTRY_VALID_TIMESTAMP_FORMAT.parse(validFrom);
                }
                if ((validUntil = (String)entry.get(ENTRY_VALID_UNTIL)) != null) {
                    snapshot.to = ENTRY_VALID_TIMESTAMP_FORMAT.parse(validUntil);
                } else {
                    snapshot.to = deletion.getRegistrationDateInternal();
                    lastSnapshot = snapshot;
                }
                newSnapshots.add(snapshot);
            }
            if (lastSnapshot == null) {
                Snapshot snapshot = new Snapshot();
                snapshot.entityCode = entityCode;
                snapshot.entityPermId = entityPermId;
                snapshot.from = registrationTimestamp != null ? registrationTimestamp : new Date(0L);
                snapshot.to = deletion.getRegistrationDateInternal();
                newSnapshots.add(snapshot);
                lastSnapshot = snapshot;
            }
            if (lastSeenTimestampOrNull != null && !deletion.getRegistrationDateInternal().after(lastSeenTimestampOrNull)) continue;
            NewEvent newEvent = NewEvent.fromOldEventPE(deletion);
            newEvent.entitySpaceCode = lastSnapshot.spaceCode;
            newEvent.entityProjectPermId = lastSnapshot.projectPermId;
            newEvent.entityExperimentPermId = lastSnapshot.experimentPermId;
            newEvent.entitySamplePermId = lastSnapshot.samplePermId;
            newEvent.entityUnknownPermId = lastSnapshot.unknownPermId;
            newEvent.entityRegisterer = registerer;
            newEvent.entityRegistrationTimestamp = registrationTimestamp;
            newEvent.identifier = entityPermId;
            newEvent.content = OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)entries);
            newEvents.add(newEvent);
        }
    }
}

