/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.AttachmentDeletionProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.DataSetDeletionProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.DataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.EventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.ExperimentDeletionProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.GenericEventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.ProjectDeletionProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SampleDeletionProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SpaceDeletionProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Statistics;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public class EventsSearchMaintenanceTask
implements IMaintenanceTask {
    public static final String DEFAULT_MAINTENANCE_TASK_NAME = "events-search-task";
    public static final int DEFAULT_MAINTENANCE_TASK_INTERVAL = 900;
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
    private final IDataSource dataSource;

    public EventsSearchMaintenanceTask() {
        this.dataSource = new DataSource();
    }

    public EventsSearchMaintenanceTask(IDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUp(String pluginName, Properties properties) {
    }

    public void execute() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.operationLog.info((Object)"Execution started...");
            Statistics statistics = this.dataSource.executeInNewTransaction(status -> {
                LastTimestamps lastTimestamps = new LastTimestamps(this.dataSource);
                SnapshotsFacade snapshots = new SnapshotsFacade(this.dataSource);
                List<EventProcessor> processors = Arrays.asList(new SpaceDeletionProcessor(this.dataSource), new ProjectDeletionProcessor(this.dataSource), new ExperimentDeletionProcessor(this.dataSource), new SampleDeletionProcessor(this.dataSource), new DataSetDeletionProcessor(this.dataSource), new AttachmentDeletionProcessor(this.dataSource), new GenericEventProcessor(this.dataSource, EventType.DELETION, EventPE.EntityType.MATERIAL), new GenericEventProcessor(this.dataSource, EventType.DELETION, EventPE.EntityType.PROPERTY_TYPE), new GenericEventProcessor(this.dataSource, EventType.DELETION, EventPE.EntityType.VOCABULARY), new GenericEventProcessor(this.dataSource, EventType.DELETION, EventPE.EntityType.AUTHORIZATION_GROUP), new GenericEventProcessor(this.dataSource, EventType.DELETION, EventPE.EntityType.METAPROJECT), new GenericEventProcessor(this.dataSource, EventType.FREEZING), new GenericEventProcessor(this.dataSource, EventType.MOVEMENT));
                for (EventProcessor processor : processors) {
                    processor.process(lastTimestamps, snapshots);
                }
                return null;
            });
            this.operationLog.info((Object)("Execution finished after: " + stopWatch.toString()));
            this.operationLog.info((Object)("Statistics: " + statistics.toString()));
        }
        catch (Throwable e) {
            this.operationLog.error((Object)("Execution failed after: " + stopWatch.toString()), e);
            throw e;
        }
    }
}

