/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.DeletionEventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class ExperimentDeletionProcessor
extends DeletionEventProcessor {
    ExperimentDeletionProcessor(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected EventPE.EntityType getEntityType() {
        return EventPE.EntityType.EXPERIMENT;
    }

    @Override
    protected Set<EventPE.EntityType> getAscendantEntityTypes() {
        return EnumSet.of(EventPE.EntityType.PROJECT);
    }

    @Override
    protected Set<EventPE.EntityType> getDescendantEntityTypes() {
        return EnumSet.of(EventPE.EntityType.SAMPLE, EventPE.EntityType.DATASET, EventPE.EntityType.ATTACHMENT);
    }

    @Override
    protected void processDeletion(LastTimestamps lastTimestamps, EventPE deletion, List<NewEvent> newEvents, List<Snapshot> newSnapshots) throws Exception {
        LinkedList<NewEvent> events = new LinkedList<NewEvent>();
        super.processDeletion(lastTimestamps, deletion, events, newSnapshots);
        for (NewEvent event : events) {
            event.description = event.identifier;
        }
        newEvents.addAll(events);
    }

    @Override
    protected void processDeletions(LastTimestamps lastTimestamps, SnapshotsFacade snapshots, List<NewEvent> newEvents, List<Snapshot> newSnapshots) {
        snapshots.putExperiments(newSnapshots);
        for (NewEvent newEvent : newEvents) {
            try {
                snapshots.fillByExperimentPermId(newEvent.identifier, newEvent);
                this.dataSource.createEventsSearch(newEvent.toNewEventPE());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Processing of deletion failed: %s", newEvent), e);
            }
        }
    }
}

