/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.EventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableObject;

public class GenericEventProcessor
extends EventProcessor {
    private final EventType eventType;
    private final EventPE.EntityType entityType;

    GenericEventProcessor(IDataSource dataSource, EventType eventType) {
        super(dataSource);
        this.eventType = eventType;
        this.entityType = null;
    }

    GenericEventProcessor(IDataSource dataSource, EventType eventType, EventPE.EntityType entityType) {
        super(dataSource);
        this.eventType = eventType;
        this.entityType = entityType;
    }

    @Override
    public final void process(LastTimestamps lastTimestamps, SnapshotsFacade snapshots) {
        List<EventPE> events;
        Date lastSeenTimestampOrNull = this.entityType != null ? lastTimestamps.getLatestOrNull(this.eventType, this.entityType) : lastTimestamps.getLatestOrNull(this.eventType, EventPE.EntityType.values());
        MutableObject latestLastSeenTimestamp = new MutableObject((Object)lastSeenTimestampOrNull);
        while (!(events = this.dataSource.loadEvents(this.eventType, this.entityType, (Date)latestLastSeenTimestamp.getValue(), 1000)).isEmpty()) {
            this.dataSource.executeInNewTransaction(status -> {
                for (EventPE event : events) {
                    try {
                        NewEvent newEvent = NewEvent.fromOldEventPE(event);
                        newEvent.identifier = event.getIdentifiers() != null ? String.join((CharSequence)", ", event.getIdentifiers()) : null;
                        this.process(lastTimestamps, snapshots, event, newEvent);
                        if (latestLastSeenTimestamp.getValue() != null && !event.getRegistrationDateInternal().after((Date)latestLastSeenTimestamp.getValue())) continue;
                        latestLastSeenTimestamp.setValue((Object)event.getRegistrationDateInternal());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Processing of deletion failed: %s", event), e);
                    }
                }
                return null;
            });
        }
    }

    protected void process(LastTimestamps lastTimestamps, SnapshotsFacade snapshots, EventPE oldEvent, NewEvent newEvent) throws Exception {
        this.dataSource.createEventsSearch(newEvent.toNewEventPE());
    }
}

