/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

class LastTimestamps {
    private final Map<Pair<EventType, EventPE.EntityType>, Date> timestamps = new HashMap<Pair<EventType, EventPE.EntityType>, Date>();

    public LastTimestamps(IDataSource dataSource) {
        for (EventType eventType : EventType.values()) {
            for (EventPE.EntityType entityType : EventPE.EntityType.values()) {
                Date lastTimestamp = dataSource.loadLastEventsSearchTimestamp(eventType, entityType);
                this.timestamps.put((Pair<EventType, EventPE.EntityType>)new ImmutablePair((Object)eventType, (Object)entityType), lastTimestamp);
            }
        }
    }

    public Date getEarliestOrNull(EventType eventType, EventPE.EntityType ... entityTypes) {
        Date earliest = null;
        for (EventPE.EntityType entityType : entityTypes) {
            Date timestamp = this.timestamps.get(new ImmutablePair((Object)eventType, (Object)entityType));
            if (timestamp == null) {
                return null;
            }
            if (earliest != null && !timestamp.before(earliest)) continue;
            earliest = timestamp;
        }
        return earliest;
    }

    public Date getLatestOrNull(EventType eventType, EventPE.EntityType ... entityTypes) {
        Date latest = null;
        for (EventPE.EntityType entityType : entityTypes) {
            Date timestamp = this.timestamps.get(new ImmutablePair((Object)eventType, (Object)entityType));
            if (timestamp == null || latest != null && !timestamp.after(latest)) continue;
            latest = timestamp;
        }
        return latest;
    }
}

