/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventsSearchPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

class NewEvent {
    public Long id;
    public EventType eventType;
    public EventPE.EntityType entityType;
    public String entitySpaceCode;
    public String entitySpacePermId;
    public String entityProject;
    public String entityProjectPermId;
    public String entityExperimentPermId;
    public String entitySamplePermId;
    public String entityUnknownPermId;
    public String entityRegisterer;
    public Date entityRegistrationTimestamp;
    public String identifier;
    public String description;
    public String reason;
    public String content;
    public Long attachmentContent;
    public PersonPE registerer;
    public Date registrationTimestamp;

    NewEvent() {
    }

    public static Set<String> getEntityExperimentPermIdsOrUnknown(Collection<NewEvent> newEvents) {
        HashSet<String> result = new HashSet<String>();
        for (NewEvent newEvent : newEvents) {
            if (newEvent.entityExperimentPermId != null) {
                result.add(newEvent.entityExperimentPermId);
                continue;
            }
            if (newEvent.entityUnknownPermId == null) continue;
            result.add(newEvent.entityUnknownPermId);
        }
        return result;
    }

    public static Set<String> getEntitySamplePermIdsOrUnknown(Collection<NewEvent> newEvents) {
        HashSet<String> result = new HashSet<String>();
        for (NewEvent newEvent : newEvents) {
            if (newEvent.entitySamplePermId != null) {
                result.add(newEvent.entitySamplePermId);
                continue;
            }
            if (newEvent.entityUnknownPermId == null) continue;
            result.add(newEvent.entityUnknownPermId);
        }
        return result;
    }

    public static NewEvent fromOldEventPE(EventPE oldEvent) {
        NewEvent newEvent = new NewEvent();
        newEvent.id = oldEvent.getId();
        newEvent.eventType = oldEvent.getEventType();
        newEvent.entityType = oldEvent.getEntityType();
        newEvent.description = oldEvent.getDescription();
        newEvent.reason = oldEvent.getReason();
        newEvent.attachmentContent = oldEvent.getAttachmentContent() != null ? HibernateUtils.getId(oldEvent.getAttachmentContent()) : null;
        newEvent.registerer = oldEvent.getRegistrator();
        newEvent.registrationTimestamp = oldEvent.getRegistrationDateInternal();
        return newEvent;
    }

    public EventsSearchPE toNewEventPE() {
        EventsSearchPE newEventPE = new EventsSearchPE();
        newEventPE.setEventType(this.eventType);
        newEventPE.setEntityType(this.entityType);
        newEventPE.setEntitySpace(this.entitySpaceCode);
        newEventPE.setEntitySpacePermId(this.entitySpacePermId);
        newEventPE.setEntityProject(this.entityProject);
        newEventPE.setEntityProjectPermId(this.entityProjectPermId);
        newEventPE.setEntityRegisterer(this.entityRegisterer);
        newEventPE.setEntityRegistrationTimestamp(this.entityRegistrationTimestamp);
        newEventPE.setIdentifier(this.identifier);
        newEventPE.setDescription(this.description);
        newEventPE.setReason(this.reason);
        newEventPE.setContent(this.content);
        newEventPE.setAttachmentContent(this.attachmentContent);
        newEventPE.setRegisterer(this.registerer);
        newEventPE.setRegistrationTimestamp(this.registrationTimestamp);
        return newEventPE;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

