/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.DeletionEventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

class ProjectDeletionProcessor
extends DeletionEventProcessor {
    ProjectDeletionProcessor(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected EventPE.EntityType getEntityType() {
        return EventPE.EntityType.PROJECT;
    }

    @Override
    protected Set<EventPE.EntityType> getAscendantEntityTypes() {
        return EnumSet.of(EventPE.EntityType.SPACE);
    }

    @Override
    protected Set<EventPE.EntityType> getDescendantEntityTypes() {
        return EnumSet.of(EventPE.EntityType.EXPERIMENT, EventPE.EntityType.SAMPLE, EventPE.EntityType.DATASET, EventPE.EntityType.ATTACHMENT);
    }

    @Override
    protected void processDeletions(LastTimestamps lastTimestamps, SnapshotsFacade snapshots, List<NewEvent> newEvents, List<Snapshot> newSnapshots) {
        snapshots.putProjects(newSnapshots);
        for (NewEvent newEvent : newEvents) {
            try {
                snapshots.fillByProjectPermId(newEvent.identifier, newEvent);
                this.dataSource.createEventsSearch(newEvent.toNewEventPE());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Processing of deletion failed: %s", newEvent), e);
            }
        }
    }
}

