/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

class Snapshots {
    private final Map<String, TreeMap<Date, Snapshot>> snapshots = new HashMap<String, TreeMap<Date, Snapshot>>();

    Snapshots() {
    }

    public void put(String key, Snapshot snapshot) {
        TreeMap snapshotsForKey = this.snapshots.computeIfAbsent(key, k -> new TreeMap());
        snapshotsForKey.put(snapshot.from, snapshot);
    }

    public Collection<Snapshot> get(Collection<String> keys) {
        ArrayList<Snapshot> snapshotsForKeys = new ArrayList<Snapshot>();
        for (String key : keys) {
            TreeMap<Date, Snapshot> snapshotsForKey = this.snapshots.get(key);
            if (snapshotsForKey == null) continue;
            snapshotsForKeys.addAll(snapshotsForKey.values());
        }
        return snapshotsForKeys;
    }

    public Snapshot get(String key, Date date) {
        Map.Entry<Date, Snapshot> potentialEntry;
        TreeMap<Date, Snapshot> snapshotsForKey = this.snapshots.get(key);
        if (snapshotsForKey != null && (potentialEntry = snapshotsForKey.floorEntry(date)) != null) {
            Snapshot potentialSnapshot = potentialEntry.getValue();
            if (potentialSnapshot.to == null || date.compareTo(potentialSnapshot.to) <= 0) {
                return potentialSnapshot;
            }
        }
        return null;
    }
}

