/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.history.ExperimentRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.IRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.RelationHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.id.UnknownRelatedObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.history.ProjectRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.history.SampleRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshots;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class SnapshotsFacade {
    private final IDataSource dataSource;
    private final Set<String> loadedSpaceCodes = new HashSet<String>();
    private final Set<String> loadedProjectPermIds = new HashSet<String>();
    private final Set<String> loadedExperimentPermIds = new HashSet<String>();
    private final Set<String> loadedSamplePermIds = new HashSet<String>();
    private final Snapshots spaceSnapshots;
    private final Snapshots projectSnapshots;
    private final Snapshots experimentSnapshots;
    private final Snapshots sampleSnapshots;
    private final Snapshots dataSetSnapshots;

    public SnapshotsFacade(IDataSource dataSource) {
        this.dataSource = dataSource;
        this.spaceSnapshots = new Snapshots();
        this.projectSnapshots = new Snapshots();
        this.experimentSnapshots = new Snapshots();
        this.sampleSnapshots = new Snapshots();
        this.dataSetSnapshots = new Snapshots();
    }

    private static Set<String> addToLoaded(Set<String> loaded, Collection<String> candidatesToLoad) {
        HashSet<String> toLoad = new HashSet<String>(candidatesToLoad);
        toLoad.removeAll(loaded);
        loaded.addAll(toLoad);
        return toLoad;
    }

    public void loadExistingSpaces(Collection<String> spaceCodes) {
        Set<String> toLoad = SnapshotsFacade.addToLoaded(this.loadedSpaceCodes, spaceCodes);
        if (toLoad.isEmpty()) {
            return;
        }
        List<SpacePE> spaces = this.dataSource.loadSpaces(new ArrayList<String>(toLoad));
        for (SpacePE space : spaces) {
            Snapshot snapshot = new Snapshot();
            snapshot.from = space.getRegistrationDateInternal();
            snapshot.entityCode = space.getCode();
            snapshot.entityPermId = space.getId().toString();
            this.spaceSnapshots.put(snapshot.entityCode, snapshot);
        }
    }

    public void loadExistingProjects(Collection<String> projectPermIds) {
        Set<String> toLoad = SnapshotsFacade.addToLoaded(this.loadedProjectPermIds, projectPermIds);
        if (toLoad.isEmpty()) {
            return;
        }
        LinkedList<Snapshot> snapshots = new LinkedList<Snapshot>();
        ProjectFetchOptions fo = new ProjectFetchOptions();
        fo.withHistory();
        List<IProjectId> ids = toLoad.stream().map(ProjectPermId::new).collect(Collectors.toList());
        List<Project> projects = this.dataSource.loadProjects(ids, fo);
        for (Project project : projects) {
            for (HistoryEntry historyEntry : project.getHistory()) {
                RelationHistoryEntry relationHistoryEntry;
                if (!(historyEntry instanceof RelationHistoryEntry) || !ProjectRelationType.SPACE.equals((Object)(relationHistoryEntry = (RelationHistoryEntry)historyEntry).getRelationType()) && (relationHistoryEntry.getRelationType() != null || relationHistoryEntry.getRelatedObjectId() == null)) continue;
                Snapshot snapshot = new Snapshot();
                snapshot.entityCode = project.getCode();
                snapshot.entityPermId = project.getPermId().getPermId();
                snapshot.from = relationHistoryEntry.getValidFrom();
                snapshot.to = relationHistoryEntry.getValidTo();
                if (ProjectRelationType.SPACE.equals((Object)relationHistoryEntry.getRelationType())) {
                    snapshot.spaceCode = ((SpacePermId)relationHistoryEntry.getRelatedObjectId()).getPermId();
                } else {
                    UnknownRelatedObjectId unknownObjectId = (UnknownRelatedObjectId)relationHistoryEntry.getRelatedObjectId();
                    if (!"OWNED".equals(unknownObjectId.getRelationType())) continue;
                    snapshot.unknownPermId = unknownObjectId.getRelatedObjectId();
                }
                snapshots.add(snapshot);
            }
        }
        this.putProjects(snapshots);
    }

    public void loadExistingExperiments(Collection<String> experimentPermIds) {
        Set<String> toLoad = SnapshotsFacade.addToLoaded(this.loadedExperimentPermIds, experimentPermIds);
        if (toLoad.isEmpty()) {
            return;
        }
        LinkedList<Snapshot> snapshots = new LinkedList<Snapshot>();
        ExperimentFetchOptions fo = new ExperimentFetchOptions();
        fo.withHistory();
        List<IExperimentId> ids = toLoad.stream().map(ExperimentPermId::new).collect(Collectors.toList());
        List<Experiment> experiments = this.dataSource.loadExperiments(ids, fo);
        for (Experiment experiment : experiments) {
            for (HistoryEntry historyEntry : experiment.getHistory()) {
                RelationHistoryEntry relationHistoryEntry;
                if (!(historyEntry instanceof RelationHistoryEntry) || !ExperimentRelationType.PROJECT.equals((Object)(relationHistoryEntry = (RelationHistoryEntry)historyEntry).getRelationType()) && (relationHistoryEntry.getRelationType() != null || relationHistoryEntry.getRelatedObjectId() == null)) continue;
                Snapshot snapshot = new Snapshot();
                snapshot.entityCode = experiment.getCode();
                snapshot.entityPermId = experiment.getPermId().getPermId();
                snapshot.from = relationHistoryEntry.getValidFrom();
                snapshot.to = relationHistoryEntry.getValidTo();
                if (ExperimentRelationType.PROJECT.equals((Object)relationHistoryEntry.getRelationType())) {
                    snapshot.projectPermId = ((ProjectPermId)relationHistoryEntry.getRelatedObjectId()).getPermId();
                } else {
                    UnknownRelatedObjectId unknownObjectId = (UnknownRelatedObjectId)relationHistoryEntry.getRelatedObjectId();
                    if (!"OWNED".equals(unknownObjectId.getRelationType())) continue;
                    snapshot.unknownPermId = unknownObjectId.getRelatedObjectId();
                }
                snapshots.add(snapshot);
            }
        }
        this.putExperiments(snapshots);
    }

    public void loadExistingSamples(Collection<String> samplePermIds) {
        Set<String> toLoad = SnapshotsFacade.addToLoaded(this.loadedSamplePermIds, samplePermIds);
        if (toLoad.isEmpty()) {
            return;
        }
        LinkedList<Snapshot> snapshots = new LinkedList<Snapshot>();
        SampleFetchOptions fo = new SampleFetchOptions();
        fo.withHistory();
        List<ISampleId> ids = toLoad.stream().map(SamplePermId::new).collect(Collectors.toList());
        List<Sample> samples = this.dataSource.loadSamples(ids, fo);
        for (Sample sample : samples) {
            for (HistoryEntry historyEntry : sample.getHistory()) {
                if (!(historyEntry instanceof RelationHistoryEntry)) continue;
                RelationHistoryEntry relationHistoryEntry = (RelationHistoryEntry)historyEntry;
                IRelationType relationType = relationHistoryEntry.getRelationType();
                IObjectId relatedObjectId = relationHistoryEntry.getRelatedObjectId();
                if (!SampleRelationType.SPACE.equals((Object)relationType) && !SampleRelationType.PROJECT.equals((Object)relationType) && !SampleRelationType.EXPERIMENT.equals((Object)relationType) && (relationType != null || relatedObjectId == null)) continue;
                Snapshot snapshot = new Snapshot();
                snapshot.entityCode = sample.getCode();
                snapshot.entityPermId = sample.getPermId().getPermId();
                snapshot.from = relationHistoryEntry.getValidFrom();
                snapshot.to = relationHistoryEntry.getValidTo();
                if (SampleRelationType.SPACE.equals((Object)relationType)) {
                    snapshot.spaceCode = ((SpacePermId)relationHistoryEntry.getRelatedObjectId()).getPermId();
                } else if (SampleRelationType.PROJECT.equals((Object)relationType)) {
                    snapshot.projectPermId = ((ProjectPermId)relationHistoryEntry.getRelatedObjectId()).getPermId();
                } else if (SampleRelationType.EXPERIMENT.equals((Object)relationType)) {
                    snapshot.experimentPermId = ((ExperimentPermId)relationHistoryEntry.getRelatedObjectId()).getPermId();
                } else {
                    UnknownRelatedObjectId unknownObjectId = (UnknownRelatedObjectId)relationHistoryEntry.getRelatedObjectId();
                    if (!"OWNED".equals(unknownObjectId.getRelationType())) continue;
                    snapshot.unknownPermId = unknownObjectId.getRelatedObjectId();
                }
                snapshots.add(snapshot);
            }
        }
        this.putSamples(snapshots);
    }

    public void putSpaces(List<Snapshot> snapshots) {
        for (Snapshot snapshot : snapshots) {
            this.spaceSnapshots.put(snapshot.entityCode, snapshot);
        }
    }

    public void putProjects(List<Snapshot> snapshots) {
        this.loadExistingSpaces(SnapshotsFacade.getSpaceCodesOrUnknown(snapshots));
        LinkedList<Snapshot> correctSnapshots = new LinkedList<Snapshot>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.unknownPermId == null) {
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot spaceSnapshot = this.getSpace(snapshot.unknownPermId, snapshot.from);
            if (spaceSnapshot == null) continue;
            snapshot.spaceCode = snapshot.unknownPermId;
            correctSnapshots.add(snapshot);
        }
        for (Snapshot correctSnapshot : correctSnapshots) {
            this.projectSnapshots.put(correctSnapshot.entityPermId, correctSnapshot);
        }
    }

    public void putExperiments(List<Snapshot> snapshots) {
        this.loadExistingProjects(SnapshotsFacade.getProjectPermIdsOrUnknown(snapshots));
        LinkedList<Snapshot> correctSnapshots = new LinkedList<Snapshot>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.unknownPermId == null) {
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot projectSnapshot = this.getProject(snapshot.unknownPermId, snapshot.from);
            if (projectSnapshot == null) continue;
            snapshot.projectPermId = snapshot.unknownPermId;
            correctSnapshots.add(snapshot);
        }
        for (Snapshot correctSnapshot : correctSnapshots) {
            this.experimentSnapshots.put(correctSnapshot.entityPermId, correctSnapshot);
        }
    }

    public void putSamples(List<Snapshot> snapshots) {
        this.loadExistingSpaces(SnapshotsFacade.getSpaceCodesOrUnknown(snapshots));
        this.loadExistingProjects(SnapshotsFacade.getProjectPermIdsOrUnknown(snapshots));
        this.loadExistingExperiments(SnapshotsFacade.getExperimentPermIdsOrUnknown(snapshots));
        LinkedList<Snapshot> correctSnapshots = new LinkedList<Snapshot>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.unknownPermId == null) {
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot experimentSnapshot = this.getExperiment(snapshot.unknownPermId, snapshot.from);
            if (experimentSnapshot != null) {
                snapshot.experimentPermId = snapshot.unknownPermId;
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot projectSnapshot = this.getProject(snapshot.unknownPermId, snapshot.from);
            if (projectSnapshot != null) {
                snapshot.projectPermId = snapshot.unknownPermId;
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot spaceSnapshot = this.getSpace(snapshot.unknownPermId, snapshot.from);
            if (spaceSnapshot == null) continue;
            snapshot.spaceCode = snapshot.unknownPermId;
            correctSnapshots.add(snapshot);
        }
        for (Snapshot correctSnapshot : correctSnapshots) {
            this.sampleSnapshots.put(correctSnapshot.entityPermId, correctSnapshot);
        }
    }

    public void putDataSets(List<Snapshot> snapshots) {
        this.loadExistingExperiments(SnapshotsFacade.getExperimentPermIdsOrUnknown(snapshots));
        this.loadExistingSamples(SnapshotsFacade.getSamplePermIdsOrUnknown(snapshots));
        LinkedList<Snapshot> correctSnapshots = new LinkedList<Snapshot>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.unknownPermId == null) {
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot experimentSnapshot = this.getExperiment(snapshot.unknownPermId, snapshot.from);
            if (experimentSnapshot != null) {
                snapshot.experimentPermId = snapshot.unknownPermId;
                correctSnapshots.add(snapshot);
                continue;
            }
            Snapshot sampleSnapshot = this.getSample(snapshot.unknownPermId, snapshot.from);
            if (sampleSnapshot == null) continue;
            snapshot.samplePermId = snapshot.unknownPermId;
            correctSnapshots.add(snapshot);
        }
        for (Snapshot correctSnapshot : correctSnapshots) {
            this.dataSetSnapshots.put(correctSnapshot.entityPermId, correctSnapshot);
        }
    }

    public Snapshot getSpace(String spaceCode, Date date) {
        return this.spaceSnapshots.get(spaceCode, date);
    }

    public Snapshot getProject(String projectPermId, Date date) {
        return this.projectSnapshots.get(projectPermId, date);
    }

    public Snapshot getExperiment(String experimentPermId, Date date) {
        return this.experimentSnapshots.get(experimentPermId, date);
    }

    public Snapshot getSample(String samplePermId, Date date) {
        return this.sampleSnapshots.get(samplePermId, date);
    }

    public void fillBySpaceCode(String spaceCode, NewEvent newEvent) {
        Snapshot spaceSnapshot = this.spaceSnapshots.get(spaceCode, newEvent.registrationTimestamp);
        if (spaceSnapshot != null) {
            newEvent.entitySpaceCode = spaceSnapshot.entityCode;
            newEvent.entitySpacePermId = spaceSnapshot.entityPermId;
        } else {
            newEvent.entitySpaceCode = spaceCode;
        }
    }

    public void fillByProjectPermId(String projectPermId, NewEvent newEvent) {
        Snapshot projectSnapshot = this.projectSnapshots.get(projectPermId, newEvent.registrationTimestamp);
        if (projectSnapshot != null) {
            newEvent.entityProjectPermId = projectPermId;
            this.fillBySpaceCode(projectSnapshot.spaceCode, newEvent);
            if (newEvent.entitySpaceCode != null) {
                newEvent.entityProject = new ProjectIdentifier(newEvent.entitySpaceCode, projectSnapshot.entityCode).toString();
            }
        } else {
            newEvent.entityProjectPermId = projectPermId;
        }
    }

    public void fillByExperimentPermId(String experimentPermId, NewEvent newEvent) {
        Snapshot experimentSnapshot = this.experimentSnapshots.get(experimentPermId, newEvent.registrationTimestamp);
        if (experimentSnapshot != null) {
            this.fillByProjectPermId(experimentSnapshot.projectPermId, newEvent);
        }
    }

    public void fillBySamplePermId(String samplePermId, NewEvent newEvent) {
        Snapshot sampleSnapshot = this.sampleSnapshots.get(samplePermId, newEvent.registrationTimestamp);
        if (sampleSnapshot != null) {
            if (sampleSnapshot.experimentPermId != null) {
                this.fillByExperimentPermId(sampleSnapshot.experimentPermId, newEvent);
            } else if (sampleSnapshot.projectPermId != null) {
                this.fillByProjectPermId(sampleSnapshot.projectPermId, newEvent);
            } else if (sampleSnapshot.spaceCode != null) {
                this.fillBySpaceCode(sampleSnapshot.spaceCode, newEvent);
            }
        }
    }

    public void fillByDataSetPermId(String dataSetPermId, NewEvent newEvent) {
        Snapshot dataSetSnapshot = this.dataSetSnapshots.get(dataSetPermId, newEvent.registrationTimestamp);
        if (dataSetSnapshot != null) {
            if (dataSetSnapshot.experimentPermId != null) {
                this.fillByExperimentPermId(dataSetSnapshot.experimentPermId, newEvent);
            } else if (dataSetSnapshot.samplePermId != null) {
                this.fillBySamplePermId(dataSetSnapshot.samplePermId, newEvent);
            }
        }
    }

    public static Set<String> getSpaceCodesOrUnknown(Collection<Snapshot> snapshots) {
        HashSet<String> result = new HashSet<String>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.spaceCode != null) {
                result.add(snapshot.spaceCode);
                continue;
            }
            if (snapshot.unknownPermId == null) continue;
            result.add(snapshot.unknownPermId);
        }
        return result;
    }

    public static Set<String> getProjectPermIdsOrUnknown(Collection<Snapshot> snapshots) {
        HashSet<String> result = new HashSet<String>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.projectPermId != null) {
                result.add(snapshot.projectPermId);
                continue;
            }
            if (snapshot.unknownPermId == null) continue;
            result.add(snapshot.unknownPermId);
        }
        return result;
    }

    public static Set<String> getExperimentPermIdsOrUnknown(Collection<Snapshot> snapshots) {
        HashSet<String> result = new HashSet<String>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.experimentPermId != null) {
                result.add(snapshot.experimentPermId);
                continue;
            }
            if (snapshot.unknownPermId == null) continue;
            result.add(snapshot.unknownPermId);
        }
        return result;
    }

    public static Set<String> getSamplePermIdsOrUnknown(Collection<Snapshot> snapshots) {
        HashSet<String> result = new HashSet<String>();
        for (Snapshot snapshot : snapshots) {
            if (snapshot.samplePermId != null) {
                result.add(snapshot.samplePermId);
                continue;
            }
            if (snapshot.unknownPermId == null) continue;
            result.add(snapshot.unknownPermId);
        }
        return result;
    }
}

