/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task.events_search;

import ch.systemsx.cisd.openbis.generic.server.task.events_search.DeletionEventProcessor;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.IDataSource;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.LastTimestamps;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.NewEvent;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.Snapshot;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.SnapshotsFacade;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

class SpaceDeletionProcessor
extends DeletionEventProcessor {
    SpaceDeletionProcessor(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected EventPE.EntityType getEntityType() {
        return EventPE.EntityType.SPACE;
    }

    @Override
    protected Set<EventPE.EntityType> getAscendantEntityTypes() {
        return Collections.emptySet();
    }

    @Override
    protected Set<EventPE.EntityType> getDescendantEntityTypes() {
        return EnumSet.of(EventPE.EntityType.PROJECT, EventPE.EntityType.EXPERIMENT, EventPE.EntityType.SAMPLE, EventPE.EntityType.DATASET);
    }

    @Override
    protected void processDeletions(LastTimestamps lastTimestamps, SnapshotsFacade snapshots, List<NewEvent> newEvents, List<Snapshot> newSnapshots) {
        for (Snapshot newSnapshot : newSnapshots) {
            newSnapshot.entityCode = newSnapshot.entityPermId;
            newSnapshot.entityPermId = null;
        }
        snapshots.putSpaces(newSnapshots);
        for (NewEvent newEvent : newEvents) {
            try {
                snapshots.fillBySpaceCode(newEvent.identifier, newEvent);
                this.dataSource.createEventsSearch(newEvent.toNewEventPE());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Processing of deletion failed: %s", newEvent), e);
            }
        }
    }
}

