/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.util;

import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonEntityValidationCalculator;
import ch.systemsx.cisd.openbis.generic.shared.IJythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.JythonManagedPropertyEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PluginUtils {
    public static final String EMAIL_ADDRESSES_KEY = "email-addresses";

    public static void checkScriptCompilation(ScriptPE script, IJythonEvaluatorPool evaluatorPool) {
        PluginType pluginType = script.getPluginType();
        if (pluginType == PluginType.PREDEPLOYED) {
            return;
        }
        String scriptExpression = script.getScript();
        ScriptType scriptType = script.getScriptType();
        if (scriptType == ScriptType.MANAGED_PROPERTY) {
            new JythonManagedPropertyEvaluator(scriptExpression);
        } else if (scriptType == ScriptType.DYNAMIC_PROPERTY) {
            JythonDynamicPropertyCalculator calculator = JythonDynamicPropertyCalculator.create(scriptExpression, evaluatorPool);
            calculator.checkScriptCompilation();
        } else {
            JythonEntityValidationCalculator calculator = JythonEntityValidationCalculator.create(scriptExpression, null, evaluatorPool);
            calculator.checkScriptCompilation();
        }
    }

    public static List<EMailAddress> getEMailAddresses(Properties properties, String delim) {
        String[] tokens = PropertyUtils.getMandatoryProperty((Properties)properties, (String)EMAIL_ADDRESSES_KEY).split(delim);
        ArrayList<EMailAddress> addresses = new ArrayList<EMailAddress>();
        for (String token : tokens) {
            addresses.add(new EMailAddress(token.trim()));
        }
        return addresses;
    }
}

