/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.util;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;

public final class SpaceIdentifierHelper {
    private SpaceIdentifierHelper() {
    }

    public static final SpacePE tryGetSpace(SpaceIdentifier spaceIdentifier, PersonPE person, IAuthorizationDAOFactory daoFactory) {
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceIdentifier);
        ISpaceDAO groupDAO = daoFactory.getSpaceDAO();
        return groupDAO.tryFindSpaceByCode(spaceCode);
    }

    public static ProjectPE tryGetProject(ProjectIdentifier projectIdentifier, PersonPE person, IAuthorizationDAOFactory daoFactory) {
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, projectIdentifier);
        IProjectDAO projectDAO = daoFactory.getProjectDAO();
        return projectDAO.tryFindProject(spaceCode, projectIdentifier.getProjectCode());
    }
}

