/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.openbis.common.api.client.IServicePinger;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;

public abstract class AbstractOpenBisServiceFactory<T> {
    private final String initialServerUrl;
    private final String urlServiceSuffix;
    private final Class<T> clazz;

    public AbstractOpenBisServiceFactory(String serverUrl, String urlServiceSuffix, Class<T> clazz) {
        this.initialServerUrl = serverUrl;
        this.urlServiceSuffix = urlServiceSuffix;
        this.clazz = clazz;
    }

    public T createService() {
        return (T)this.createServiceFinder().createService(this.clazz, this.initialServerUrl, this.createServicePinger());
    }

    public T createService(long timeoutInMillis) {
        return (T)this.createServiceFinder().createService(this.clazz, this.initialServerUrl, this.createServicePinger(), timeoutInMillis);
    }

    private ServiceFinder createServiceFinder() {
        return new ServiceFinder("openbis", this.urlServiceSuffix);
    }

    protected abstract IServicePinger<T> createServicePinger();
}

