/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.ISessionProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public interface IServer
extends ISessionProvider {
    public static final int VERSION = 35;

    public int getVersion();

    public Map<String, String> getServerInformation(String var1);

    @Transactional(readOnly=true)
    public boolean isArchivingConfigured(String var1);

    @Transactional(readOnly=true)
    public boolean isProjectSamplesEnabled(String var1);

    @Transactional(readOnly=true)
    public boolean isProjectLevelAuthorizationEnabled(String var1);

    @Transactional(readOnly=true)
    public boolean isProjectLevelAuthorizationUser(String var1);

    @Transactional
    public SessionContextDTO tryAuthenticate(String var1, String var2);

    @Transactional
    public SessionContextDTO tryAuthenticateAs(String var1, String var2, String var3);

    @Transactional
    public SessionContextDTO tryAuthenticateAnonymously();

    @Transactional
    public SessionContextDTO tryToAuthenticate(String var1);

    public SessionContextDTO tryGetSession(String var1);

    public void checkSession(String var1) throws InvalidSessionException;

    @Transactional
    public void setBaseIndexURL(String var1, String var2);

    @Transactional
    public String getBaseIndexURL(String var1);

    @Transactional
    public DisplaySettings getDefaultDisplaySettings(String var1);

    @Transactional
    public void saveDisplaySettings(String var1, DisplaySettings var2, int var3);

    @Transactional
    public void updateDisplaySettings(String var1, IDisplaySettingsUpdate var2);

    @Transactional
    public List<GridCustomColumn> listGridCustomColumns(String var1, String var2);

    @Transactional
    public void changeUserHomeSpace(String var1, TechId var2);

    public void logout(String var1) throws UserFailureException;

    public void expireSession(String var1) throws UserFailureException;

    @Transactional
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PERSON, DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP, DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT})
    public void deactivatePersons(String var1, List<String> var2);

    @Transactional(readOnly=true)
    public int countActivePersons(String var1);

    @Transactional(readOnly=true)
    public void setSessionUser(String var1, String var2);
}

