/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;

public class TableCellUtil {
    public static final String USER_PREFIX = "USER-";
    public static final String INTERN_PREFIX = "INTERN-";

    public static ISerializableComparable createTableCell(String token) {
        if (token == null) {
            return StringTableCell.EMPTY_CELL;
        }
        try {
            return new IntegerTableCell(Long.parseLong(token));
        }
        catch (NumberFormatException ex) {
            try {
                return new DoubleTableCell(Double.parseDouble(token));
            }
            catch (NumberFormatException numberFormatException) {
                return new StringTableCell(token);
            }
        }
    }

    public static String getPropertyTypeCode(PropertyType propertyType) {
        return (propertyType.isManagedInternally() ? INTERN_PREFIX : USER_PREFIX) + propertyType.getSimpleCode();
    }

    public static boolean isEditiableProperty(PropertyType propertyType) {
        DataTypeCode dataType = propertyType.getDataType().getCode();
        switch (dataType) {
            case REAL: 
            case INTEGER: 
            case VARCHAR: 
            case MULTILINE_VARCHAR: 
            case BOOLEAN: 
            case DATE: 
            case TIMESTAMP: 
            case CONTROLLEDVOCABULARY: 
            case MATERIAL: 
            case SAMPLE: 
            case HYPERLINK: {
                return true;
            }
            case XML: {
                return false;
            }
        }
        throw new UnsupportedOperationException("");
    }

    private TableCellUtil() {
    }
}

