/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.io.Serializable;

public final class EntityKindAndTypeCode
implements Serializable {
    private static final long serialVersionUID = 35L;
    private final EntityKind entityKind;
    private final String entityTypeCode;

    public EntityKindAndTypeCode(EntityKind entityKind, BasicEntityType entityType) {
        this(entityKind, entityType.getCode());
    }

    public EntityKindAndTypeCode(EntityKind entityKind, String entityTypeCode) {
        assert (entityKind != null) : "Unspecified entity kind.";
        assert (entityTypeCode != null) : "Unspecified entity type code.";
        this.entityKind = entityKind;
        this.entityTypeCode = entityTypeCode;
    }

    public boolean entityKindsMatch(EntityKindAndTypeCode other) {
        return this.entityKind.equals((Object)other.entityKind);
    }

    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityKindAndTypeCode)) {
            return false;
        }
        EntityKindAndTypeCode that = (EntityKindAndTypeCode)obj;
        return this.entityKind.equals((Object)that.entityKind) && this.entityTypeCode.equals(that.entityTypeCode);
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + this.entityKind.hashCode();
        result = 37 * result + this.entityTypeCode.hashCode();
        return result;
    }

    public final String toString() {
        return "[entityKind=" + this.entityKind + ",entityTypeCode=" + this.entityTypeCode + "]";
    }
}

