/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import java.io.Serializable;

public final class MaterialIdentifier
implements Serializable {
    private static final long serialVersionUID = 35L;
    public static final String TYPE_SEPARATOR_PREFIX = " (";
    public static final String TYPE_SEPARATOR_SUFFIX = ")";
    private String code;
    private String typeCode;

    public MaterialIdentifier() {
    }

    public MaterialIdentifier(String code, String typeCode) {
        this.code = code;
        this.typeCode = typeCode;
    }

    public MaterialIdentifier(IEntityInformationHolderWithPermId material) {
        this(material.getCode(), material.getEntityType().getCode());
    }

    public final String getCode() {
        return this.code;
    }

    public final void setCode(String code) {
        this.code = code;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public static MaterialIdentifier tryCreate(String codeOrIdentifierOrNull, ICodeHolder materialTypeCodeHolderOrNull) {
        MaterialIdentifier materialIdentifier = MaterialIdentifier.tryParseIdentifier(codeOrIdentifierOrNull);
        if (materialIdentifier != null) {
            if (materialTypeCodeHolderOrNull != null && !materialIdentifier.getTypeCode().equals(materialTypeCodeHolderOrNull.getCode())) {
                throw new IllegalArgumentException("Material identified by '" + materialIdentifier + "' has to be of type " + materialTypeCodeHolderOrNull.getCode() + ".");
            }
            return materialIdentifier;
        }
        if (materialTypeCodeHolderOrNull != null && !StringUtils.isBlank((String)codeOrIdentifierOrNull)) {
            return new MaterialIdentifier(codeOrIdentifierOrNull, materialTypeCodeHolderOrNull.getCode());
        }
        return null;
    }

    public static MaterialIdentifier tryParseIdentifier(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        int typePrefix = value.indexOf(TYPE_SEPARATOR_PREFIX);
        if (typePrefix == -1) {
            return null;
        }
        String code = value.substring(0, typePrefix);
        String typeCode = value.substring(typePrefix + TYPE_SEPARATOR_PREFIX.length());
        if (typeCode.endsWith(TYPE_SEPARATOR_SUFFIX)) {
            typeCode = typeCode.substring(0, typeCode.length() - TYPE_SEPARATOR_SUFFIX.length());
        }
        return new MaterialIdentifier(code, typeCode);
    }

    public String print() {
        return MaterialIdentifier.print(this.getCode(), this.getTypeCode());
    }

    public static String print(String code, String typeCode) {
        return MaterialIdentifier.toString(code, typeCode);
    }

    public static String toString(String code, String typeCode) {
        return code + TYPE_SEPARATOR_PREFIX + typeCode + TYPE_SEPARATOR_SUFFIX;
    }

    public final boolean equals(Object obj) {
        assert (this.code != null) : "code not given";
        assert (this.typeCode != null) : "type not given";
        if (obj == null || !(obj instanceof MaterialIdentifier)) {
            return false;
        }
        MaterialIdentifier that = (MaterialIdentifier)obj;
        return this.code.equals(that.code) && this.typeCode.equals(that.typeCode);
    }

    public final int hashCode() {
        assert (this.code != null) : "code not given";
        assert (this.typeCode != null) : "type not given";
        return this.code.hashCode() ^ this.typeCode.hashCode();
    }

    public String toString() {
        return this.print();
    }
}

