/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RoleWithHierarchy
extends Enum<RoleWithHierarchy>
implements Serializable {
    public static final /* enum */ RoleWithHierarchy INSTANCE_DISABLED = new RoleWithHierarchy(true);
    public static final /* enum */ RoleWithHierarchy INSTANCE_ADMIN = new RoleWithHierarchy(new RoleWithHierarchy[0]);
    public static final /* enum */ RoleWithHierarchy INSTANCE_OBSERVER = new RoleWithHierarchy(INSTANCE_ADMIN);
    public static final /* enum */ RoleWithHierarchy INSTANCE_ETL_SERVER = new RoleWithHierarchy(INSTANCE_ADMIN);
    public static final /* enum */ RoleWithHierarchy SPACE_ADMIN = new RoleWithHierarchy(INSTANCE_ADMIN);
    public static final /* enum */ RoleWithHierarchy SPACE_POWER_USER = new RoleWithHierarchy(SPACE_ADMIN);
    public static final /* enum */ RoleWithHierarchy SPACE_USER = new RoleWithHierarchy(SPACE_POWER_USER);
    public static final /* enum */ RoleWithHierarchy SPACE_OBSERVER = new RoleWithHierarchy(SPACE_USER, INSTANCE_OBSERVER);
    public static final /* enum */ RoleWithHierarchy SPACE_ETL_SERVER = new RoleWithHierarchy(INSTANCE_ETL_SERVER);
    public static final /* enum */ RoleWithHierarchy PROJECT_ADMIN = new RoleWithHierarchy(SPACE_ADMIN);
    public static final /* enum */ RoleWithHierarchy PROJECT_POWER_USER = new RoleWithHierarchy(PROJECT_ADMIN, SPACE_POWER_USER);
    public static final /* enum */ RoleWithHierarchy PROJECT_USER = new RoleWithHierarchy(PROJECT_POWER_USER, SPACE_USER);
    public static final /* enum */ RoleWithHierarchy PROJECT_OBSERVER = new RoleWithHierarchy(PROJECT_USER, SPACE_OBSERVER);
    private static final String ERROR_MSG_ROLE_DOESN_T_MATCH_NAMING_CONVENTION = "Role doesn't match naming convention";
    private static final String SEPARATOR = "_";
    private final RoleCode roleCode;
    private final RoleLevel roleLevel;
    private final boolean completelyEmpty;
    private final Set<RoleWithHierarchy> strongerRoles = new LinkedHashSet<RoleWithHierarchy>();
    private static final /* synthetic */ RoleWithHierarchy[] $VALUES;

    public static RoleWithHierarchy[] values() {
        return (RoleWithHierarchy[])$VALUES.clone();
    }

    public static RoleWithHierarchy valueOf(String name) {
        return Enum.valueOf(RoleWithHierarchy.class, name);
    }

    public static RoleWithHierarchy valueOf(RoleLevel roleLevel, RoleCode roleCode) {
        return RoleWithHierarchy.valueOf(roleLevel.name() + SEPARATOR + roleCode.name());
    }

    private RoleWithHierarchy(boolean completelyEmpty) {
        this.completelyEmpty = completelyEmpty;
        this.roleLevel = RoleWithHierarchy.figureRoleLevel(this.name());
        this.roleCode = RoleWithHierarchy.figureRoleCode(this.name(), this.roleLevel);
    }

    private RoleWithHierarchy(RoleWithHierarchy ... strongerRoles) {
        this.completelyEmpty = false;
        this.roleLevel = RoleWithHierarchy.figureRoleLevel(this.name());
        this.roleCode = RoleWithHierarchy.figureRoleCode(this.name(), this.roleLevel);
        for (RoleWithHierarchy strongerRole : strongerRoles) {
            this.getStrongerRoles().add(strongerRole);
            for (RoleWithHierarchy role : strongerRole.getStrongerRoles()) {
                this.getStrongerRoles().add(role);
            }
        }
    }

    private Set<RoleWithHierarchy> getStrongerRoles() {
        return this.strongerRoles;
    }

    static RoleLevel figureRoleLevel(String roleWithHierarchyName) {
        for (RoleLevel level : RoleLevel.values()) {
            if (!roleWithHierarchyName.startsWith(level.name() + SEPARATOR)) continue;
            return level;
        }
        throw new IllegalArgumentException(ERROR_MSG_ROLE_DOESN_T_MATCH_NAMING_CONVENTION);
    }

    static RoleCode figureRoleCode(String roleWithHierarchyName, RoleLevel roleLevel) {
        assert (roleWithHierarchyName.startsWith(roleLevel.name() + SEPARATOR));
        for (RoleCode code : RoleCode.values()) {
            if (!code.name().equals(roleWithHierarchyName.substring(roleLevel.name().length() + 1))) continue;
            return code;
        }
        throw new IllegalArgumentException(ERROR_MSG_ROLE_DOESN_T_MATCH_NAMING_CONVENTION);
    }

    public Set<RoleWithHierarchy> getRoles() {
        LinkedHashSet<RoleWithHierarchy> roles = new LinkedHashSet<RoleWithHierarchy>();
        if (!this.completelyEmpty) {
            roles.add(this);
        }
        roles.addAll(this.strongerRoles);
        return roles;
    }

    public boolean isInstanceLevel() {
        return this.roleLevel.equals((Object)RoleLevel.INSTANCE);
    }

    public boolean isSpaceLevel() {
        return this.roleLevel.equals((Object)RoleLevel.SPACE);
    }

    public boolean isProjectLevel() {
        return this.roleLevel.equals((Object)RoleLevel.PROJECT);
    }

    public RoleLevel getRoleLevel() {
        return this.roleLevel;
    }

    public final RoleCode getRoleCode() {
        return this.roleCode;
    }

    public String toString() {
        return this.name();
    }

    static {
        $VALUES = new RoleWithHierarchy[]{INSTANCE_DISABLED, INSTANCE_ADMIN, INSTANCE_OBSERVER, INSTANCE_ETL_SERVER, SPACE_ADMIN, SPACE_POWER_USER, SPACE_USER, SPACE_OBSERVER, SPACE_ETL_SERVER, PROJECT_ADMIN, PROJECT_POWER_USER, PROJECT_USER, PROJECT_OBSERVER};
    }

    public static enum RoleCode implements IsSerializable
    {
        DISABLED,
        ADMIN,
        USER,
        POWER_USER,
        OBSERVER,
        ETL_SERVER;

    }

    public static enum RoleLevel implements IsSerializable
    {
        INSTANCE,
        SPACE,
        PROJECT;

    }
}

