/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.conversation;

import ch.systemsx.cisd.openbis.common.api.client.IServicePinger;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.common.conversation.manager.IServiceConversationClientManagerRemote;
import ch.systemsx.cisd.openbis.common.conversation.manager.IServiceConversationServerManagerRemote;

public class ServiceConversationApplicationServerUrl {
    private String applicationServerUrl;
    private String clientUrl;
    private String serverUrl;

    public ServiceConversationApplicationServerUrl(String applicationServerUrl) {
        this.applicationServerUrl = applicationServerUrl;
    }

    public String getClientUrl(int timeout) {
        if (this.clientUrl == null) {
            IServicePinger<IServiceConversationClientManagerRemote> pinger = new IServicePinger<IServiceConversationClientManagerRemote>(){

                public void ping(IServiceConversationClientManagerRemote service) {
                    service.ping();
                }
            };
            ServiceFinder finder = new ServiceFinder("openbis", "/service-conversation-client-manager");
            this.clientUrl = finder.createServiceUrl(IServiceConversationClientManagerRemote.class, this.applicationServerUrl, (IServicePinger)pinger, (long)timeout);
        }
        return this.clientUrl;
    }

    public String getServerUrl(int timeout) {
        if (this.serverUrl == null) {
            IServicePinger<IServiceConversationServerManagerRemote> pinger = new IServicePinger<IServiceConversationServerManagerRemote>(){

                public void ping(IServiceConversationServerManagerRemote service) {
                    service.ping();
                }
            };
            ServiceFinder finder = new ServiceFinder("openbis", "/service-conversation-server-manager");
            this.serverUrl = finder.createServiceUrl(IServiceConversationServerManagerRemote.class, this.applicationServerUrl, (IServicePinger)pinger, (long)timeout);
        }
        return this.serverUrl;
    }
}

