/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.coreplugin;

import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import java.io.File;
import java.util.Properties;

public class CorePluginsUtils {
    public static final String CORE_PLUGINS_FOLDER_KEY = "core-plugins-folder";
    static final String DEFAULT_CORE_PLUGINS_FOLDER = "../core-plugins";
    static final String DEFAULT_AS_CORE_PLUGINS_FOLDER = "../../core-plugins";
    public static final String CORE_PLUGINS_PROPERTIES_FILE = "core-plugins.properties";

    public static void addCorePluginsProperties(Properties properties, CorePluginScanner.ScannerType scannerType) {
        String corePluginsFolder = CorePluginsUtils.getCorePluginsFolder(properties, scannerType);
        File file = new File(corePluginsFolder, CORE_PLUGINS_PROPERTIES_FILE);
        PropertyIOUtils.loadAndAppendProperties((Properties)properties, (File)file);
    }

    public static String getCorePluginsFolder(Properties properties, CorePluginScanner.ScannerType scannerType) {
        String defaultCorePluginsFolder = scannerType == CorePluginScanner.ScannerType.DSS ? DEFAULT_CORE_PLUGINS_FOLDER : DEFAULT_AS_CORE_PLUGINS_FOLDER;
        return properties.getProperty(CORE_PLUGINS_FOLDER_KEY, defaultCorePluginsFolder);
    }
}

