/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.coreplugin;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ModuleEnabledChecker {
    private static final IKeyExtractor<String, CorePlugin> CORE_PLUGIN_NAME_EXTRACTOR = new IKeyExtractor<String, CorePlugin>(){

        public String getKey(CorePlugin corePlugin) {
            return corePlugin.getName();
        }
    };
    private final List<Pattern> enabledModulesPatterns = new ArrayList<Pattern>();

    public ModuleEnabledChecker(Properties properties, String key) {
        this(PropertyUtils.getList((Properties)properties, (String)key));
    }

    public ModuleEnabledChecker(List<String> moduleRegExs) {
        for (String regex : moduleRegExs) {
            try {
                this.enabledModulesPatterns.add(Pattern.compile(regex));
            }
            catch (PatternSyntaxException ex) {
                throw new ConfigurationFailureException("Invalid regular expression: " + ex.getMessage());
            }
        }
    }

    public Set<CorePlugin> getModuleWithEnabledMasterDataInitializations(List<CorePlugin> corePlugins) {
        LinkedHashSet<CorePlugin> result = new LinkedHashSet<CorePlugin>();
        TableMap pluginsByName = new TableMap(corePlugins, CORE_PLUGIN_NAME_EXTRACTOR);
        for (String enabledPlugin : this.getEnabledPlugins(corePlugins)) {
            CorePlugin plugin;
            String name;
            if (!enabledPlugin.equals(name = (plugin = this.getPluginByFullRequiredPluginName((TableMap<String, CorePlugin>)pluginsByName, enabledPlugin, null)).getName()) && !enabledPlugin.equals(name + ":" + "initialize-master-data")) continue;
            result.add(plugin);
        }
        return result;
    }

    Set<String> getEnabledPlugins(List<CorePlugin> corePlugins) {
        TableMap pluginsByName = new TableMap(corePlugins, CORE_PLUGIN_NAME_EXTRACTOR);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (CorePlugin corePlugin : this.getListOfEnabledPlugins(corePlugins)) {
            this.addRequiredPlugins(result, new HashSet<CorePlugin>(), (TableMap<String, CorePlugin>)pluginsByName, corePlugin);
            result.add(corePlugin.getName());
        }
        return result;
    }

    private void addRequiredPlugins(Set<String> result, Set<CorePlugin> visitedPlugins, TableMap<String, CorePlugin> pluginsByName, CorePlugin corePlugin) {
        if (visitedPlugins.contains(corePlugin)) {
            return;
        }
        visitedPlugins.add(corePlugin);
        for (String requiredPlugin : corePlugin.getRequiredPlugins()) {
            CorePlugin referredPlugin = this.getPluginByFullRequiredPluginName(pluginsByName, requiredPlugin, corePlugin);
            this.addRequiredPlugins(result, visitedPlugins, pluginsByName, referredPlugin);
            result.add(requiredPlugin);
        }
    }

    private CorePlugin getPluginByFullRequiredPluginName(TableMap<String, CorePlugin> pluginsByName, String requiredPlugin, CorePlugin corePlugin) {
        FullPluginName fullPluginName = new FullPluginName(requiredPlugin);
        String moduleName = fullPluginName.getModule();
        CorePlugin referredPlugin = (CorePlugin)pluginsByName.tryGet((Object)moduleName);
        if (referredPlugin == null) {
            throw new ConfigurationFailureException("Required plugin '" + requiredPlugin + "' specified by core plugin '" + corePlugin + "' refers to the unknown module '" + moduleName + "'.");
        }
        return referredPlugin;
    }

    List<CorePlugin> getListOfEnabledPlugins(List<CorePlugin> corePlugins) {
        ArrayList<CorePlugin> result = new ArrayList<CorePlugin>();
        ArrayList<String> codes = new ArrayList<String>();
        HashMap<String, CorePlugin> codeToPlugin = new HashMap<String, CorePlugin>();
        for (CorePlugin plugin : corePlugins) {
            String name = plugin.getName();
            codes.add(name);
            codeToPlugin.put(name, plugin);
        }
        for (String enabledPluginCode : this.getListOfEnabledModules(codes)) {
            result.add((CorePlugin)codeToPlugin.get(enabledPluginCode));
        }
        return result;
    }

    public List<String> getListOfEnabledModules(List<String> moduleNames) {
        LinkedList<String> remainingModules = new LinkedList<String>(moduleNames);
        ArrayList<String> modulesInTheRightOrder = new ArrayList<String>();
        for (Pattern pattern : this.enabledModulesPatterns) {
            Iterator it = remainingModules.iterator();
            while (it.hasNext()) {
                String module = (String)it.next();
                if (!pattern.matcher(module).matches()) continue;
                modulesInTheRightOrder.add(module);
                it.remove();
            }
        }
        return modulesInTheRightOrder;
    }

    public boolean isModuleEnabled(String module) {
        for (Pattern pattern : this.enabledModulesPatterns) {
            if (!pattern.matcher(module).matches()) continue;
            return true;
        }
        return false;
    }

    private static final class FullPluginName {
        private final String module;
        private final String pluginType;
        private final String name;

        FullPluginName(String nameAsString) {
            String[] splittedName = nameAsString.split(":");
            this.module = splittedName[0];
            if (splittedName.length > 1) {
                this.pluginType = splittedName[1];
                this.name = splittedName.length > 2 ? splittedName[2] : null;
            } else {
                this.pluginType = null;
                this.name = null;
            }
        }

        public String getModule() {
            return this.module;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.module);
            if (this.pluginType != null) {
                builder.append(':').append(this.pluginType);
                if (this.name != null) {
                    builder.append(':').append(this.name);
                }
            }
            return builder.toString();
        }
    }
}

