/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.type.DbTimestampType;

@Entity
@Table(name="data_set_relationships", uniqueConstraints={@UniqueConstraint(columnNames={"data_id_parent", "data_id_child", "relationship_id"})})
@IdClass(value=DataSetRelationshipId.class)
@TypeDefs(value={@TypeDef(name="transactiontimestamp", typeClass=DbTimestampType.class)})
public class DataSetRelationshipPE
implements Serializable {
    private static final long serialVersionUID = 35L;
    private DataPE parentDataSet;
    private boolean parentFrozen;
    private boolean containerFrozen;
    private DataPE childDataSet;
    private boolean childFrozen;
    private boolean componentFrozen;
    private PersonPE author;
    private Date registrationDate;
    private Date modificationDate;
    private RelationshipTypePE relationshipType;
    private Integer ordinal;
    private DeletionPE deletion;

    private DataSetRelationshipPE() {
    }

    public DataSetRelationshipPE(DataPE parentDataSet, DataPE childDataSet, RelationshipTypePE relationshipType, Integer ordinal, PersonPE author) {
        this.setParentDataSet(parentDataSet);
        this.setChildDataSet(childDataSet);
        this.relationshipType = relationshipType;
        this.ordinal = ordinal;
        this.author = author;
    }

    @NotNull(message="Parent can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="data_id_parent")
    @Id
    public DataPE getParentDataSet() {
        return this.parentDataSet;
    }

    public void setParentDataSet(DataPE parentDataSet) {
        this.parentDataSet = parentDataSet;
        if (parentDataSet != null) {
            this.parentFrozen = parentDataSet.isFrozen() && parentDataSet.isFrozenForChildren();
            this.containerFrozen = parentDataSet.isFrozen() && parentDataSet.isFrozenForComponents();
        }
    }

    @NotNull
    @Column(name="parent_frozen", nullable=false)
    public boolean isParentFrozen() {
        if (this.parentDataSet != null) {
            this.parentFrozen = this.parentDataSet.isFrozen() && this.parentDataSet.isFrozenForChildren();
        }
        return this.parentFrozen;
    }

    public void setParentFrozen(boolean parentFrozen) {
        this.parentFrozen = parentFrozen;
    }

    @NotNull
    @Column(name="cont_frozen", nullable=false)
    public boolean isContainerFrozen() {
        if (this.parentDataSet != null) {
            this.containerFrozen = this.parentDataSet.isFrozen() && this.parentDataSet.isFrozenForComponents();
        }
        return this.containerFrozen;
    }

    public void setContainerFrozen(boolean containerFrozen) {
        this.containerFrozen = containerFrozen;
    }

    @NotNull(message="Child can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="data_id_child")
    @Id
    public DataPE getChildDataSet() {
        return this.childDataSet;
    }

    public void setChildDataSet(DataPE childDataSet) {
        this.childDataSet = childDataSet;
        if (childDataSet != null) {
            this.childFrozen = childDataSet.isFrozen() && childDataSet.isFrozenForParents();
            this.componentFrozen = childDataSet.isFrozen() && childDataSet.isFrozenForContainers();
        }
    }

    @NotNull
    @Column(name="child_frozen", nullable=false)
    public boolean isChildFrozen() {
        if (this.childDataSet != null) {
            this.childFrozen = this.childDataSet.isFrozen() && this.childDataSet.isFrozenForParents();
        }
        return this.childFrozen;
    }

    public void setChildFrozen(boolean childFrozen) {
        this.childFrozen = childFrozen;
    }

    @NotNull
    @Column(name="comp_frozen", nullable=false)
    public boolean isComponentFrozen() {
        if (this.childDataSet != null) {
            this.componentFrozen = this.childDataSet.isFrozen() && this.childDataSet.isFrozenForContainers();
        }
        return this.componentFrozen;
    }

    public void setComponentFrozen(boolean componentFrozen) {
        this.componentFrozen = componentFrozen;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pers_id_author")
    public PersonPE getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonPE author) {
        this.author = author;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    @Type(type="transactiontimestamp")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @NotNull(message="Relationship can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="relationship_id")
    @Id
    public RelationshipTypePE getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipTypePE relationship) {
        this.relationshipType = relationship;
    }

    @Column(name="ordinal")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }
}

