/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@Table(name="events_search")
public class EventsSearchPE
implements IIdHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private EventType eventType;
    private EventPE.EntityType entityType;
    private String entitySpace;
    private String entitySpacePermId;
    private String entityProject;
    private String entityProjectPermId;
    private String entityRegisterer;
    private Date entityRegistrationTimestamp;
    private String identifier;
    private String description;
    private String reason;
    private String content;
    private Long attachmentContent;
    private PersonPE registerer;
    private Date registrationTimestamp;

    public final void setId(Long id) {
        this.id = id;
    }

    @Id
    @SequenceGenerator(name="EVENTS_SEARCH_ID_SEQ", sequenceName="EVENTS_SEARCH_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EVENTS_SEARCH_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @NotNull(message="Event Type can not be null.")
    @Column(name="event_type")
    @Enumerated(value=EnumType.STRING)
    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @NotNull(message="Entity Type can not be null.")
    @Column(name="entity_type")
    @Enumerated(value=EnumType.STRING)
    public EventPE.EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EventPE.EntityType entityType) {
        this.entityType = entityType;
    }

    @NotNull(message="Identifier can not be null.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Column(name="entity_space")
    public String getEntitySpace() {
        return this.entitySpace;
    }

    public void setEntitySpace(String entitySpace) {
        this.entitySpace = entitySpace;
    }

    @Column(name="entity_space_perm_id")
    public String getEntitySpacePermId() {
        return this.entitySpacePermId;
    }

    public void setEntitySpacePermId(String entitySpacePermId) {
        this.entitySpacePermId = entitySpacePermId;
    }

    @Column(name="entity_project")
    public String getEntityProject() {
        return this.entityProject;
    }

    public void setEntityProject(String entityProject) {
        this.entityProject = entityProject;
    }

    @Column(name="entity_project_perm_id")
    public String getEntityProjectPermId() {
        return this.entityProjectPermId;
    }

    public void setEntityProjectPermId(String entityProjectPermId) {
        this.entityProjectPermId = entityProjectPermId;
    }

    @Column(name="entity_registerer")
    public String getEntityRegisterer() {
        return this.entityRegisterer;
    }

    public void setEntityRegisterer(String entityRegisterer) {
        this.entityRegisterer = entityRegisterer;
    }

    @Column(name="entity_registration_timestamp")
    public Date getEntityRegistrationTimestamp() {
        return this.entityRegistrationTimestamp;
    }

    public void setEntityRegistrationTimestamp(Date entityRegistrationTimestamp) {
        this.entityRegistrationTimestamp = entityRegistrationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Column(name="exac_id")
    public Long getAttachmentContent() {
        return this.attachmentContent;
    }

    public void setAttachmentContent(Long attachmentContent) {
        this.attachmentContent = attachmentContent;
    }

    @Column(name="registration_timestamp", nullable=false, updatable=false)
    public Date getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    public void setRegistrationTimestamp(Date registrationTimestamp) {
        this.registrationTimestamp = registrationTimestamp;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pers_id_registerer", nullable=false, updatable=false)
    public PersonPE getRegisterer() {
        return this.registerer;
    }

    public void setRegisterer(PersonPE registerer) {
        this.registerer = registerer;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)true);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)true);
    }
}

