/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractEntityHistoryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IRelatedEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedProject;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelatedSample;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="experiment_history_view")
public class ExperimentHistoryPE
extends AbstractEntityHistoryPE {
    private static final long serialVersionUID = 35L;
    private Long projectId;
    private Long dataSetId;
    private Long sampleId;

    @ManyToOne(fetch=FetchType.LAZY, targetEntity=ExperimentPE.class)
    @JoinColumn(name="main_expe_id")
    ExperimentPE getEntityInternal() {
        return (ExperimentPE)this.entity;
    }

    private void setEntityInternal(ExperimentPE experiment) {
        this.entity = experiment;
    }

    @ManyToOne(fetch=FetchType.EAGER, targetEntity=ExperimentTypePropertyTypePE.class)
    @JoinColumn(name="etpt_id")
    public EntityTypePropertyTypePE getEntityTypePropertyTypeInternal() {
        return this.entityTypePropertyType;
    }

    private void setEntityTypePropertyTypeInternal(ExperimentTypePropertyTypePE experimentTypePropertyType) {
        this.entityTypePropertyType = experimentTypePropertyType;
    }

    @Column(name="samp_id")
    public Long getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(Long sampleId) {
        this.sampleId = sampleId;
    }

    @Column(name="data_id")
    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    @Column(name="proj_id")
    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    @Transient
    public IRelatedEntity getRelatedEntity() {
        if (this.sampleId != null) {
            return new RelatedSample(this.sampleId);
        }
        if (this.dataSetId != null) {
            return new RelatedDataSet(this.dataSetId);
        }
        if (this.projectId != null) {
            return new RelatedProject(this.projectId);
        }
        return null;
    }
}

