/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.UnmodifiableListDecorator;
import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="experiments", uniqueConstraints={@UniqueConstraint(columnNames={"code", "proj_id"})})
@Friend(toClasses={AttachmentPE.class, ProjectPE.class})
public class ExperimentPE
extends AttachmentHolderPE
implements IEntityInformationWithPropertiesHolder,
IIdAndCodeHolder,
Comparable<ExperimentPE>,
IModifierAndModificationDateBean,
IMatchingEntity,
IDeletablePE,
IEntityWithMetaprojects,
IIdentityHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    public static final ExperimentPE[] EMPTY_ARRAY = new ExperimentPE[0];
    private transient Long id;
    private String code;
    private boolean frozen;
    private boolean frozenForSample;
    private boolean frozenForDataSet;
    private ProjectPE project;
    private boolean projectFrozen;
    private ExperimentTypePE experimentType;
    private DeletionPE deletion;
    private Set<ExperimentPropertyPE> properties = new HashSet<ExperimentPropertyPE>();
    private List<SamplePE> samples = new ArrayList<SamplePE>();
    private List<DataPE> dataSets = new ArrayList<DataPE>();
    private Date lastDataSetDate;
    private ExperimentIdentifier experimentIdentifier;
    private Set<MetaprojectAssignmentPE> metaprojectAssignments = new HashSet<MetaprojectAssignmentPE>();
    private PersonPE registrator;
    private PersonPE modifier;
    private Date registrationDate;
    private Date modificationDate;
    private int version;
    private Integer originalDeletion;
    private String permId;

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Override
    @OptimisticLock(excluded=true)
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_modifier")
    public PersonPE getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(PersonPE modifier) {
        this.modifier = modifier;
    }

    @Id
    @SequenceGenerator(name="EXPERIMENT_ID_SEQ", sequenceName="EXPERIMENT_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EXPERIMENT_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="code")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @NotNull(message="Code can not be null.")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @NotNull
    @Column(name="frozen", nullable=false)
    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @NotNull
    @Column(name="frozen_for_samp", nullable=false)
    public boolean isFrozenForSample() {
        return this.frozenForSample;
    }

    public void setFrozenForSample(boolean frozenForSample) {
        this.frozenForSample = frozenForSample;
    }

    @NotNull
    @Column(name="frozen_for_data", nullable=false)
    public boolean isFrozenForDataSet() {
        return this.frozenForDataSet;
    }

    public void setFrozenForDataSet(boolean frozenForDataSet) {
        this.frozenForDataSet = frozenForDataSet;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Project can not be null.")
    @JoinColumn(name="proj_id", updatable=true)
    private ProjectPE getProjectInternal() {
        return this.project;
    }

    @Private
    void setProjectInternal(ProjectPE project) {
        this.project = project;
        if (project != null) {
            this.projectFrozen = project.isFrozen() && project.isFrozenForExperiment();
        }
        this.experimentIdentifier = null;
    }

    @Transient
    public ProjectPE getProject() {
        return this.getProjectInternal();
    }

    public void setProject(ProjectPE project) {
        project.addExperiment(this);
    }

    @NotNull
    @Column(name="proj_frozen", nullable=false)
    public boolean isProjectFrozen() {
        if (this.project != null) {
            this.projectFrozen = this.project.isFrozen() && this.project.isFrozenForExperiment();
        }
        return this.projectFrozen;
    }

    public void setProjectFrozen(boolean projectFrozen) {
        this.projectFrozen = projectFrozen;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Experiment type can not be null.")
    @JoinColumn(name="exty_id", updatable=false)
    public ExperimentTypePE getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(ExperimentTypePE experimentType) {
        this.experimentType = experimentType;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity", orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=100)
    private Set<ExperimentPropertyPE> getExperimentProperties() {
        return this.properties;
    }

    private void setExperimentProperties(Set<ExperimentPropertyPE> properties) {
        this.properties = properties;
    }

    @Transient
    public Set<ExperimentPropertyPE> getProperties() {
        return new UnmodifiableSetDecorator(this.getExperimentProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getExperimentProperties());
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getExperimentProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            ExperimentPropertyPE experimentProperty = (ExperimentPropertyPE)entityPropertyPE;
            ExperimentPE parent = experimentProperty.getEntity();
            if (parent != null) {
                parent.getExperimentProperties().remove(experimentProperty);
            }
            this.addProperty(experimentProperty);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        property.setEntityFrozen(this.isFrozen());
        this.getExperimentProperties().add((ExperimentPropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getExperimentProperties().remove(property);
        property.setEntity(null);
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, mappedBy="experimentParentInternal", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    protected Set<AttachmentPE> getInternalAttachments() {
        return this.attachments;
    }

    @Transient
    public List<SamplePE> getSamples() {
        return new UnmodifiableListDecorator(this.getExperimentSamples());
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="experimentInternal")
    private List<SamplePE> getExperimentSamples() {
        return this.samples;
    }

    private void setExperimentSamples(List<SamplePE> samples) {
        this.samples = samples;
    }

    public void setSamples(List<SamplePE> samples) {
        this.getExperimentSamples().clear();
        for (SamplePE sample : samples) {
            this.addSample(sample);
        }
    }

    public void removeSample(SamplePE sample) {
        this.getExperimentSamples().remove(sample);
        sample.setExperimentInternal(null);
    }

    public void addSample(SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        if (experiment != null) {
            experiment.getExperimentSamples().remove(sample);
        }
        sample.setExperimentInternal(this);
        sample.setProject(this.project);
        this.getExperimentSamples().add(sample);
    }

    @Transient
    public List<DataPE> getDataSets() {
        return new UnmodifiableListDecorator(this.getExperimentDataSets());
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="experimentInternal")
    private List<DataPE> getExperimentDataSets() {
        return this.dataSets;
    }

    private void setExperimentDataSets(List<DataPE> dataSets) {
        this.dataSets = dataSets;
    }

    @Transient
    public void removeDataSet(DataPE dataSet) {
        this.getExperimentDataSets().remove(dataSet);
    }

    public void addDataSet(DataPE child) {
        ExperimentPE parent = child.getExperiment();
        if (parent != null) {
            parent.removeDataSet(child);
        }
        child.setExperimentInternal(this);
        this.getExperimentDataSets().add(child);
    }

    @Transient
    public Date getLastDataSetDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.lastDataSetDate);
    }

    public void setLastDataSetDate(Date lastDataSetDate) {
        this.lastDataSetDate = lastDataSetDate;
    }

    @Override
    public int compareTo(ExperimentPE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getProject(), "project");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentPE)) {
            return false;
        }
        ExperimentPE that = (ExperimentPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getProject(), (Object)that.getProject());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getProject());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("project", (Object)this.getProject());
        builder.append("experimentType", (Object)this.getExperimentType());
        builder.append("deletion", (Object)this.getDeletion());
        return builder.toString();
    }

    @Transient
    public final String getIdentifier() {
        if (this.experimentIdentifier == null) {
            this.experimentIdentifier = IdentifierHelper.createExperimentIdentifier(this);
        }
        return this.experimentIdentifier.toString();
    }

    @Override
    @Transient
    public final EntityTypePE getEntityType() {
        return this.getExperimentType();
    }

    @Override
    @Transient
    public final EntityKind getEntityKind() {
        return EntityKind.EXPERIMENT;
    }

    @Override
    @OptimisticLock(excluded=true)
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Column(name="orig_del", nullable=false)
    public Integer getOriginalDeletion() {
        return this.originalDeletion;
    }

    public void setOriginalDeletion(Integer originalDeletion) {
        this.originalDeletion = originalDeletion;
    }

    @Override
    @Transient
    public AttachmentHolderKind getAttachmentHolderKind() {
        return AttachmentHolderKind.EXPERIMENT;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    public String getPermId() {
        return this.permId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    @Override
    public void addMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setExperiment(this);
        this.getMetaprojectAssignmentsInternal().add(assignmentPE);
        metaprojectPE.getAssignmentsInternal().add(assignmentPE);
    }

    @Override
    public void removeMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setExperiment(this);
        this.getMetaprojectAssignmentsInternal().remove(assignmentPE);
        metaprojectPE.getAssignmentsInternal().remove(assignmentPE);
    }

    @Override
    @Transient
    public Set<MetaprojectPE> getMetaprojects() {
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        for (MetaprojectAssignmentPE assignment : this.getMetaprojectAssignmentsInternal()) {
            metaprojects.add(assignment.getMetaproject());
        }
        return new UnmodifiableSetDecorator(metaprojects);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="experiment", orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<MetaprojectAssignmentPE> getMetaprojectAssignmentsInternal() {
        return this.metaprojectAssignments;
    }

    private void setMetaprojectAssignmentsInternal(Set<MetaprojectAssignmentPE> metaprojectAssignments) {
        this.metaprojectAssignments = metaprojectAssignments;
    }
}

