/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystemType;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="external_data_management_systems")
public class ExternalDataManagementSystemPE
extends AbstractIdAndCodeHolder<ExternalDataManagementSystemPE>
implements IIdentityHolder {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private String code;
    private String label;
    private String address;
    private ExternalDataManagementSystemType addressType;

    @Id
    @SequenceGenerator(name="EXTERNAL_DATA_MANAGEMENT_SYSTEM_ID_SEQ", sequenceName="EXTERNAL_DATA_MANAGEMENT_SYSTEM_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EXTERNAL_DATA_MANAGEMENT_SYSTEM_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Column(name="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name="address_type")
    @Enumerated(value=EnumType.STRING)
    @NotNull
    public ExternalDataManagementSystemType getAddressType() {
        return this.addressType;
    }

    public void setAddressType(ExternalDataManagementSystemType addressType) {
        this.addressType = addressType;
    }

    @Transient
    public boolean isOpenBIS() {
        return ExternalDataManagementSystemType.OPENBIS.equals((Object)this.addressType);
    }

    @Override
    @Transient
    public String getPermId() {
        return this.code;
    }

    @Transient
    public String getIdentifier() {
        return this.code;
    }
}

