/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@MappedSuperclass
public abstract class HibernateAbstractRegistrationHolder
implements Serializable {
    private static final long serialVersionUID = 35L;
    private PersonPE registrator;
    private Date registrationDate;

    public static final Date getDate(Date date) {
        if (date == null) {
            return null;
        }
        String packageName = date.getClass().getPackage().getName();
        if (packageName.equals("java.sql")) {
            return new Date(date.getTime());
        }
        return date;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    @Transient
    public Date getRegistrationDateInternal() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }
}

