/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="materials", uniqueConstraints={@UniqueConstraint(columnNames={"code", "maty_id"})})
public class MaterialPE
implements IIdAndCodeHolder,
Comparable<MaterialPE>,
IEntityInformationWithPropertiesHolder,
Serializable,
IMatchingEntity,
IEntityWithMetaprojects,
IIdentityHolder,
IModificationDateBean {
    private static final long serialVersionUID = 35L;
    public static final MaterialPE[] EMPTY_ARRAY = new MaterialPE[0];
    private transient Long id;
    private MaterialTypePE materialType;
    private String code;
    private Set<MaterialPropertyPE> properties = new HashSet<MaterialPropertyPE>();
    private Set<MetaprojectAssignmentPE> metaprojectAssignments = new HashSet<MetaprojectAssignmentPE>();
    private PersonPE registrator;
    private Date registrationDate;
    private Date modificationDate;

    public static String createPermId(String code, String materialTypeCode) {
        return code + " (" + materialTypeCode + ")";
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Id
    @SequenceGenerator(name="MATERIAL_ID_SEQ", sequenceName="MATERIAL_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MATERIAL_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Material type can not be null.")
    @JoinColumn(name="maty_id", updatable=false)
    public MaterialTypePE getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(MaterialTypePE materialType) {
        this.materialType = materialType;
    }

    @Column(name="code")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @NotNull(message="Code can not be null.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity", orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=100)
    private Set<MaterialPropertyPE> getMaterialProperties() {
        return this.properties;
    }

    private void setMaterialProperties(Set<MaterialPropertyPE> properties) {
        this.properties = properties;
    }

    @Transient
    public Set<MaterialPropertyPE> getProperties() {
        return new UnmodifiableSetDecorator(this.getMaterialProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getMaterialProperties());
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getMaterialProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            MaterialPropertyPE materialProperty = (MaterialPropertyPE)entityPropertyPE;
            MaterialPE parent = materialProperty.getEntity();
            if (parent != null) {
                parent.getMaterialProperties().remove(materialProperty);
            }
            this.addProperty(materialProperty);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        this.getMaterialProperties().add((MaterialPropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getMaterialProperties().remove(property);
        property.setEntity(null);
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getMaterialType(), "type");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MaterialPE)) {
            return false;
        }
        MaterialPE that = (MaterialPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getMaterialType(), (Object)that.getMaterialType());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getMaterialType());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("materialType", (Object)this.getMaterialType());
        return builder.toString();
    }

    @Override
    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Override
    public final int compareTo(MaterialPE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    @Transient
    public final String getIdentifier() {
        return this.getCode();
    }

    @Override
    @Transient
    public final EntityTypePE getEntityType() {
        return this.getMaterialType();
    }

    @Override
    @Transient
    public final EntityKind getEntityKind() {
        return EntityKind.MATERIAL;
    }

    @Override
    @Transient
    public String getPermId() {
        return MaterialPE.createPermId(this.code, this.materialType.getCode());
    }

    @Override
    public void addMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setMaterial(this);
        this.getMetaprojectAssignmentsInternal().add(assignmentPE);
        metaprojectPE.getAssignmentsInternal().add(assignmentPE);
    }

    @Override
    public void removeMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setMaterial(this);
        this.getMetaprojectAssignmentsInternal().remove(assignmentPE);
        metaprojectPE.getAssignmentsInternal().remove(assignmentPE);
    }

    @Override
    @Transient
    public Set<MetaprojectPE> getMetaprojects() {
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        for (MetaprojectAssignmentPE assignment : this.getMetaprojectAssignmentsInternal()) {
            metaprojects.add(assignment.getMetaproject());
        }
        return new UnmodifiableSetDecorator(metaprojects);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="material")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<MetaprojectAssignmentPE> getMetaprojectAssignmentsInternal() {
        return this.metaprojectAssignments;
    }

    private void setMetaprojectAssignmentsInternal(Set<MetaprojectAssignmentPE> metaprojectAssignments) {
        this.metaprojectAssignments = metaprojectAssignments;
    }
}

