/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Table(name="metaproject_assignments")
public class MetaprojectAssignmentPE
implements Serializable,
IIdHolder {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private MetaprojectPE metaproject;
    private ExperimentPE experiment;
    private SamplePE sample;
    private DataPE dataSet;
    private MaterialPE material;
    private DeletionPE deletion;

    @Id
    @SequenceGenerator(name="METAPROJECT_ASSIGNMENT_ID_SEQ", sequenceName="METAPROJECT_ASSIGNMENT_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="METAPROJECT_ASSIGNMENT_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Metaproject can not be null.")
    @JoinColumn(name="mepr_id", updatable=false)
    public MetaprojectPE getMetaproject() {
        return this.metaproject;
    }

    public void setMetaproject(MetaprojectPE metaproject) {
        this.metaproject = metaproject;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="expe_id", updatable=false)
    public ExperimentPE getExperiment() {
        return this.experiment;
    }

    public void setExperiment(ExperimentPE experiment) {
        this.experiment = experiment;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="samp_id", updatable=false)
    public SamplePE getSample() {
        return this.sample;
    }

    public void setSample(SamplePE sample) {
        this.sample = sample;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="data_id", updatable=false)
    public DataPE getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataPE dataSet) {
        this.dataSet = dataSet;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="mate_id", updatable=false)
    public MaterialPE getMaterial() {
        return this.material;
    }

    public void setMaterial(MaterialPE material) {
        this.material = material;
    }

    public void setEntity(IEntityWithMetaprojects entity) {
        if (entity instanceof MaterialPE) {
            this.setMaterial((MaterialPE)entity);
        } else if (entity instanceof DataPE) {
            this.setDataSet((DataPE)entity);
        } else if (entity instanceof ExperimentPE) {
            this.setExperiment((ExperimentPE)entity);
        } else if (entity instanceof SamplePE) {
            this.setSample((SamplePE)entity);
        } else {
            throw new NullPointerException("Must specify entity to set.");
        }
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getMetaproject(), "metaproject");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetaprojectAssignmentPE)) {
            return false;
        }
        MetaprojectAssignmentPE that = (MetaprojectAssignmentPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getMetaproject(), (Object)that.getMetaproject());
        builder.append((Object)this.getExperiment(), (Object)that.getExperiment());
        builder.append((Object)this.getSample(), (Object)that.getSample());
        builder.append((Object)this.getDataSet(), (Object)that.getDataSet());
        builder.append((Object)this.getMaterial(), (Object)that.getMaterial());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getMetaproject());
        builder.append((Object)this.getExperiment());
        builder.append((Object)this.getSample());
        builder.append((Object)this.getDataSet());
        builder.append((Object)this.getMaterial());
        return builder.toHashCode();
    }
}

