/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="metaprojects", uniqueConstraints={@UniqueConstraint(columnNames={"name", "owner"})})
public class MetaprojectPE
implements Serializable,
IIdHolder,
ICodeHolder,
IIdentityHolder {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private String name;
    private String description;
    private PersonPE owner;
    private boolean isPrivate;
    private Date creationDate;
    private Set<MetaprojectAssignmentPE> assignments = new HashSet<MetaprojectAssignmentPE>();

    @Id
    @SequenceGenerator(name="METAPROJECT_ID_SEQ", sequenceName="METAPROJECT_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="METAPROJECT_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @NotNull(message="Name can not be null.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Transient
    public String getCode() {
        return this.getName();
    }

    @Transient
    public String getIdentifier() {
        return new MetaprojectIdentifier(this.getOwner() != null ? this.getOwner().getUserId() : null, this.getName()).format();
    }

    @Override
    @Transient
    public String getPermId() {
        return null;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Owner can not be null.")
    @JoinColumn(name="owner", updatable=false)
    public PersonPE getOwner() {
        return this.owner;
    }

    public void setOwner(PersonPE owner) {
        this.owner = owner;
    }

    @Column(name="private")
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Column(name="creation_date", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.ALWAYS)
    public Date getCreationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.creationDate);
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="metaproject", orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    Set<MetaprojectAssignmentPE> getAssignmentsInternal() {
        return this.assignments;
    }

    private void setAssignmentsInternal(Set<MetaprojectAssignmentPE> assignments) {
        this.assignments = assignments;
    }

    @Transient
    public Set<MetaprojectAssignmentPE> getAssignments() {
        return Collections.unmodifiableSet(this.getAssignmentsInternal());
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getName(), "name");
        EqualsHashUtils.assertDefined(this.getOwner(), "owner");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetaprojectPE)) {
            return false;
        }
        MetaprojectPE that = (MetaprojectPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getName(), (Object)that.getName());
        builder.append((Object)this.getOwner(), (Object)that.getOwner());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getName());
        builder.append((Object)this.getOwner());
        return builder.toHashCode();
    }
}

